<?php
/**
 * ThemeOptions
 *
 * @author     ThemesDeveloper support@themesdeveloper.com
 * @copyright  2013-2015 ThemesDeveloper
 * @license    http://www.php.net/license/3_01.txt  PHP License 3.0
 */
if (!defined('_PS_VERSION_'))
    exit;

class TDpsThemeOptionPanel extends Module {

    public $idshop, $idshopgroup, $languages, $default_language, $_html, $pattern, $successmeg;
    public $tdoptions = array();
    public $tdthemename = "td_";

    public function __construct() {
        $this->name = 'tdpsthemeoptionpanel';
        $this->tab = 'front_office_features';
        $this->version = '2.0.1'; //2.0.1 theme options for all themesdeveloper themes
        $this->author = 'ThemesDeveloper';
        $this->secure_key = Tools::encrypt($this->name);
        $this->default_language = (int) (Configuration::get('PS_LANG_DEFAULT'));
        $this->languages = Language::getLanguages(false);
        parent::__construct();
        $this->displayName = $this->l('Metros Theme Options Panel');
        $this->description = $this->l('Metros Prestashop Themes Option Panel By ThemesDeveloper');
        $this->module_path = _PS_MODULE_DIR_ . $this->name . '/';
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
        $this->tdpsBaseModeURL = __PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/';
        $this->backofficImage = __PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/img/';
        $this->backofficJS = __PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/js/';
        $this->backofficCSS = __PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/css/';
        $this->patternsURL = __PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/bg/';
        $this->patternsDIR = _PS_MODULE_DIR_ . 'tdpsthemeoptionpanel/bg/';
        $this->themeImageURL = _PS_BASE_URL_SSL_ . __PS_BASE_URI__ . 'themes/metros/img/metros/';
        $this->themeCSSURL = __PS_BASE_URI__ . 'themes/metros/css/metros/';
        $this->themeJSURL = __PS_BASE_URI__ . 'themes/metros/js/metros/';
        $this->themeImage = __PS_BASE_URI__ . 'themes/metros/img/';
        $this->tdshopBaseURL = _PS_BASE_URL_ . __PS_BASE_URI__;
        $this->getBgPatern();
        $shop_name = array();
        $shop_group = array();
        $gettdshop = Shop::getShops();
        foreach ($gettdshop as $totalshopgroup) {
            $shopgroup = Shop::getGroupFromShop($totalshopgroup['id_shop'], false);
            $shop_name[$totalshopgroup['id_shop']] = $totalshopgroup['name'];
            $shop_group[$totalshopgroup['id_shop_group']] = $shopgroup['name'];
        }
        $this->idshop = $shop_name;
        $this->idshopgroup = $shop_group;
        $this->tdThemeOption();
    }

    public function install() {
        if (!parent::install() ||
                !$this->registerHook('displayHeader') ||
                !$this->registerHook('displayTop') ||
                !$this->registerHook('displayLeftColumn') ||
                !$this->registerHook('displayRightColumn') ||
                !$this->registerHook('displayHome') ||
                !$this->registerHook('displayFooter') ||
                !$this->installDefaultValue()
        )
            return false;

        return true;
    }

    public function uninstall() {
        $tdoptions = $this->tdoptions;
        if (!parent::uninstall())
            return false;

        foreach ($tdoptions as $option_result) {
            $getsavevaluevalue = isset($option_result['std']) ? $option_result['std'] : '';
            if (isset($getsavevaluevalue)) {
                if (is_array($getsavevaluevalue)) {
                    foreach ($getsavevaluevalue as $key => $output_value) {
                        Configuration::deleteByName($option_result['id'] . '_' . $key);
                    }
                } else {
                    if (isset($option_result['lang']) && $option_result['lang'] == true) {
                        foreach ($this->languages as $lang) {
                            Configuration::deleteByName($option_result['id'] . '_' . $lang['id_lang']);
                        }
                    } else {
                        if (isset($option_result['id']))
                            Configuration::deleteByName($option_result['id']);
                    }
                }
            }
        }

        return true;
    }

    public function hookdisplayTop() {
        global $smarty;
        $tdpsthemeoptionpanel = array();
        foreach ($this->tdoptions as $option_value):
            if ($option_value['type'] == 'typography') {
                foreach ($option_value as $values) {
                    if (is_array($values)) {
                        foreach ($values as $key => $typovalue) {
                            $tdpsthemeoptionpanel[$option_value['id'] . '_' . $key] = Configuration::get($option_value['id'] . '_' . $key);
                        }
                    }
                }
            }
            if (isset($option_value['id'])):
                $tdpsthemeoptionpanel[$option_value['id']] = Configuration::get($option_value['id']);
            endif;
            if (isset($option_value['lang']) && $option_value['lang'] == true):

                foreach ($this->languages as $lang) {
                    $tdpsthemeoptionpanel[$option_value['id'] . '_' . $lang['id_lang']] = Configuration::get($option_value['id'] . '_' . $lang['id_lang']);
                }
                $tdpsthemeoptionpanel[$option_value['id']] = Configuration::get($option_value['id'] . '_' . $this->context->language->id);
            endif;
        endforeach;
        $smarty->assign('themesdev', $tdpsthemeoptionpanel);
    }

    public function hookdisplayHome() {
        return $this->hookdisplayTop();
    }

    public function hookdisplayHeader() {
        $this->styleCustom();
        return $this->hookdisplayTop();
    }

    public function hookdisplayFooter() {
        return $this->hookdisplayTop();
    }

    public function hookdisplayLeftColumn() {
        return $this->hookdisplayTop();
    }

    public function hookdisplayRightColumn() {
        return $this->hookdisplayTop();
    }

    public function getContent() {
        $this->_html = '';
        require_once '../config/config.inc.php';
        require_once '../init.php';

        $this->_html .= '
<link href="' . $this->backofficCSS . 'style.css" rel="stylesheet" type="text/css" />
<link href="' . $this->backofficCSS . 'colorpicker.css" rel="stylesheet" type="text/css" />
<link href="' . $this->backofficCSS . 'bootstrap.css" rel="stylesheet" type="text/css" />
<script src="' . $this->backofficJS . 'colorpicker.js" type="text/javascript"></script>
<script src="' . $this->backofficJS . 'medialibrary-uploader.js" type="text/javascript" ></script>
<script src="' . $this->backofficJS . 'bootstrap.js" type="text/javascript" ></script>
<script src="' . $this->backofficJS . 'options-custom.js" type="text/javascript" ></script>
    <script>
    jQuery(document).ready(function($) {
    	//AJAX Upload
                        $(".uploadbtn").each(function(){
                        //e.preventDefault();
			var btnpostid = $(this).attr("id");	
                        var btnpostobject = $(this);
			new AjaxUpload(btnpostid, {
				  action: "' . $this->tdpsBaseModeURL . 'tdpsthemeoptionpanelAjax.php",
				  name: btnpostid, 
				  data: {
						action: "tdajax_post_action",
						type: "upload_btntype",
						data: btnpostid },
				  autoSubmit: true,
				  responseType: false,
				  onSubmit: function(file, ext){
                                              // Allow only images. You should add security check on the server-side.
                                                if (ext && /^(jpg|png|jpeg|gif)$/i.test(ext)) {
                                                    this.disable(); 
                                                    btnpostobject.text("Uploading");
                                                    interval = window.setInterval(function(){
                                                    var text = btnpostobject.text();
                                                    if (text.length <16){btnpostobject.text(text + "."); }
                                                    else { btnpostobject.text("Uploading"); } 
						}, 200);
                                                } else {
                                                    alert("Only JPG, PNG or GIF files are allowed");
                                                    return false;
                                                } 
				  },
				  onComplete: function(file, res) {
                                        this.enable();
					window.clearInterval(interval);
					btnpostobject.text("Upload");	
                                        var return_data = \'<img  alt="" class="td-upload-image" id="upimage_\'+btnpostid+\'" src="\'+res+\'" />\';
                                        $("#upimage_" + btnpostid).remove();	
                                        btnpostobject.parent().after(return_data);
                                        $("img#upimage_"+btnpostid).fadeIn();
                                        btnpostobject.next("span").fadeIn();
                                        btnpostobject.parent().prev("input").val(res);
                                        }
				});
			
			});
			 //AJAX Reset Options
                         $(".resetbtn").click(function(){
                                   var resetimagetitle = jQuery(this).attr("title");	
                                    var data = {
                                            action: "tdajax_post_action",
                                            type: "reset_btntype",
                                            data: resetimagetitle
                                    };
                                    var btnpostobject = $(this);
                                    $.post("' . $this->tdpsBaseModeURL . 'tdpsthemeoptionpanelAjax.php", 
                                           data, 
                                    function(response) {
                                            var resetbutton = $("#upimage_" + resetimagetitle);
                                            var resetbtnimage = $("#resimage_" + resetimagetitle);
                                            resetbutton.fadeOut(400,function(){ 
                                                btnpostobject.remove(); 
                                            });
                                            resetbtnimage.fadeOut();
                                            btnpostobject.parent().prev("input").val("");
                                    });
                                    return false; 
					
				});
              });                  
</script>';
        if (Tools::isSubmit('TDOptionvelue')) {
            $this->_insertData($_POST);
        }
        $this->_tdOptionForm();
        return $this->_html;
    }

    private function _tdOptionForm() {
        $id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        $iso = $this->context->language->iso_code;
        $tdoptionfields = $this->tdOptionPanelFields();
        //print_r($tdoptionfields);

        if (version_compare(_PS_VERSION_, '1.6.0.12') >= 0)
                 $this->_html .= '
			<script type="text/javascript">	
				var iso = \'' . (file_exists(_PS_ROOT_DIR_ . '/js/tiny_mce/langs/' . $iso . '.js') ? $iso : 'en') . '\' ;
				var pathCSS = \'' . _THEME_CSS_DIR_ . '\' ;
				var ad = \'' . dirname($_SERVER['PHP_SELF']) . '\' ;
			</script>
			<script type="text/javascript" src="' . __PS_BASE_URI__ . 'js/tiny_mce/tiny_mce.js"></script>
			<script type="text/javascript" src="' . __PS_BASE_URI__ . 'js/admin/tinymce.inc.js"></script>
			<script language="javascript" type="text/javascript">
				id_language = Number(' . $id_lang_default . ');
				tinySetup();
			</script>';
        elseif (version_compare(_PS_VERSION_, '1.4.0.0') >= 0)
            $this->_html .= '
			<script type="text/javascript">	
				var iso = \'' . (file_exists(_PS_ROOT_DIR_ . '/js/tiny_mce/langs/' . $iso . '.js') ? $iso : 'en') . '\' ;
				var pathCSS = \'' . _THEME_CSS_DIR_ . '\' ;
				var ad = \'' . dirname($_SERVER['PHP_SELF']) . '\' ;
			</script>
			<script type="text/javascript" src="' . __PS_BASE_URI__ . 'js/tiny_mce/tiny_mce.js"></script>
                        <script type="text/javascript" src="' . __PS_BASE_URI__ . 'js/tinymce.inc.js"></script>
			<script language="javascript" type="text/javascript">
				id_language = Number(' . $id_lang_default . ');
				tinySetup();
			</script>';
        else {
            $this->_html .= '
			<script type="text/javascript" src="' . __PS_BASE_URI__ . 'js/tinymce/jscripts/tiny_mce/tiny_mce.js"></script>
			<script type="text/javascript">
				tinyMCE.init({
					mode : "textareas",
					theme : "advanced",
					plugins : "safari,pagebreak,style,layer,table,advimage,advlink,inlinepopups,media,searchreplace,contextmenu,paste,directionality,fullscreen",
					theme_advanced_buttons1 : "newdocument,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,styleselect,formatselect,fontselect,fontsizeselect",
					theme_advanced_buttons2 : "cut,copy,paste,pastetext,pasteword,|,search,replace,|,bullist,numlist,|,outdent,indent,blockquote,|,undo,redo,|,link,unlink,anchor,image,cleanup,help,code,,|,forecolor,backcolor",
					theme_advanced_buttons3 : "tablecontrols,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,|,ltr,rtl,|,fullscreen",
					theme_advanced_buttons4 : "insertlayer,moveforward,movebackward,absolute,|,styleprops,|,cite,abbr,acronym,del,ins,attribs,|,pagebreak",
					theme_advanced_toolbar_location : "top",
					theme_advanced_toolbar_align : "left",
					theme_advanced_statusbar_location : "bottom",
					theme_advanced_resizing : false,
					content_css : "' . __PS_BASE_URI__ . 'themes/' . _THEME_NAME_ . '/css/global.css",
					document_base_url : "' . __PS_BASE_URI__ . '",
					width: "600",
					height: "auto",
					font_size_style_values : "8pt, 10pt, 12pt, 14pt, 18pt, 24pt, 36pt",
					template_external_list_url : "lists/template_list.js",
					external_link_list_url : "lists/link_list.js",
					external_image_list_url : "lists/image_list.js",
					media_external_list_url : "lists/media_list.js",
					elements : "nourlconvert",
					entity_encoding: "raw",
					convert_urls : false,
					language : "' . (file_exists(_PS_ROOT_DIR_ . '/js/tinymce/jscripts/tiny_mce/langs/' . $iso . '.js') ? $iso : 'en') . '"
				});
				id_language = Number(' . $id_lang_default . ');
			</script>';
        }
        $this->_html .= $this->successmeg . '
            <div class="container custome-bg tdthemeoption">
        <form id="for_form" method="post" action="index.php?tab=AdminModules&configure=' . $this->name . '&token=' . Tools::getAdminTokenLite('AdminModules') . '&tab_module=front_office_features&module_name=' . $this->name . '" enctype="multipart/form-data" >
            <div class="header_wrap">
                        <h2>' . $this->displayName . '</h2>';
        $this->_html .= 'Theme Option by <a href="http://themesdeveloper.com" target="_blank">ThemesDeveloper</a>, <a href="http://themeforest.net/user/themesdeveloper?ref=themesdeveloper" target="_blank">View Profile</a>, <a href="http://themeforest.net/user/themesdeveloper/portfolio?ref=themesdeveloper">View Portfolio</a>, <a href="mailto:support@themesdeveloper.com">For Support</a>
            </div>
            <div class="row-fluid">
                <div id="sidebar" class="tabbable">
                    <div class="span3">
                        <div class="well">
                            <ul id="lefttablinks" class="nav nav-pills nav-stacked">
                                 ' . $tdoptionfields[0] . ' 
                            </ul>
                        </div><!-- .well -->
                    </div><!-- .span3 -->
                    <div class="span9">				
                        <div class="tab-content content-gbcolr">
 ' . $tdoptionfields[1] . ' 
                        </div><!-- .tab-content -->
                    </div><!-- .span7 -->
                </div><!-- .tabbable -->
            </div>
              <div class="page-footer">
                     <button type="submit" name="TDOptionvelue" class="savebutton btn-button save-button">Change Update</button>
               </div>
            	</form>
	<div style="clear:both;"></div>
        </div>';

        return $this->_html;
    }

    public function getOptionConfigure($id) {
        //$id_lang_default = (int) Configuration::get('PS_LANG_DEFAULT');
        //public static function get($key, $id_lang = null, $id_shop_group = null, $id_shop = null)
        return Configuration::get($id);
    }

    public function tdOptionPanelFields() {
        $tdoptions = $this->tdoptions;
        $leftlinks = '';
        $tdfieldsoutput = '';

        $count = 0;
        foreach ($tdoptions as $tdfields) {
            $langfields = '';
            $count++;
            if ($tdfields['type'] != "heading") {
                $headingclass = '';
                if (isset($tdfields['class'])) {
                    $headingclass = $tdfields['class'];
                }
                $tdfieldsoutput .= '<div class="sectionupload  section-' . $tdfields['type'] . ' ' . $headingclass . '">';

                if ($tdfields['type'] != "innerheading") {
                    if (isset($tdfields['name']))
                        $tdfieldsoutput .= '<h3 class="heading">' . $tdfields['name'] . '</h3>';
                }else {
                    $tdfieldsoutput .= '<h3 class="innerheading">' . $tdfields['name'] . '</h3>';
                }
                if (isset($tdfields['sub_name'])) {
                    $tdfieldsoutput .= '<h5>' . $tdfields['sub_name'] . '</h5>';
                }

                if (isset($tdfields['type']) && ($tdfields['type'] == 'textarea')) {
                    if (isset($tdfields['tiny_mce']) && $tdfields['tiny_mce'] == true) {
                        $tdfieldsoutput .= '<div class="option tdtextareabox">';
                    } else {
                        $tdfieldsoutput .= '<div class="option tdtextareabox">';
                    }
                } else {
                    $tdfieldsoutput .= '<div class="option">';
                }
                if (!isset($tdfields['desc'])):
                    $tdfieldsoutput .= '<div class="manage managefull">';
                else:
                    $tdfieldsoutput .= '<div class="manage">';
                endif;
            }
            switch ($tdfields['type']) {
                // Basic block_text input
                case 'block_text':
                    $getsavevalue = $this->getOptionConfigure($tdfields['id']);
                    $tdfieldsoutput .= '<input class="td-input" name="' . $tdfields['id'] . '" id="' . $tdfields['id'] . '" type="' . $tdfields['type'] . '" value="' . $getsavevalue . '" />';
                    break;
                // Basic text input
                case 'text':
                    $getsavevalue = '';
                    $langfields.= $tdfields['id'];
                    if (isset($tdfields['lang']) && $tdfields['lang'] == true)
                        $getsavevalue = $this->getOptionConfigure($tdfields['id'] . '_' . $this->default_language);
                    else
                        $getsavevalue = $this->getOptionConfigure($tdfields['id']);

                    if ($getsavevalue != "") {
                        $getsavevalue = stripslashes($getsavevalue);
                    }
                    if (isset($tdfields['lang']) && $tdfields['lang'] == true):
                        foreach ($this->languages as $lang) {
                            $getsavevalue = $this->getOptionConfigure($tdfields['id'] . '_' . $lang['id_lang']);
                            if ($getsavevalue != "") {
                                $getsavevalue = stripslashes($getsavevalue);
                            }
                            $tdfieldsoutput .='<div id="' . $tdfields['id'] . '_' . $lang['id_lang'] . '" style="display: ' . ($lang['id_lang'] == $this->default_language ? 'block' : 'none') . ';float: left;">';
                            $tdfieldsoutput .= '<input class="td-input" name="' . $tdfields['id'] . '_' . $lang['id_lang'] . '" id="' . $tdfields['id'] . '_' . $lang['id_lang'] . '" type="' . $tdfields['type'] . '" value="' . $getsavevalue . '" />';
                            $tdfieldsoutput .= '</div>';
                        }
                        $tdfieldsoutput .=$this->displayFlags($this->languages, $this->default_language, $langfields, $tdfields['id'], true);
                    else:
                        $tdfieldsoutput .= '<input class="td-input" name="' . $tdfields['id'] . '" id="' . $tdfields['id'] . '" type="' . $tdfields['type'] . '" value="' . $getsavevalue . '" />';
                    endif;
                    break;
                // Select Box
                case 'select':
                    $tdfieldsoutput .= '<div class="td-select-box">';
                    $tdfieldsoutput .= '<select class="' . $tdfields['type'] . '" name="' . $tdfields['id'] . '">';
                    $selected_value = $this->getOptionConfigure($tdfields['id']);
                    foreach ($tdfields['options'] as $select_key => $option_val) {
                        $selectedoption = '';
                        if (isset($selected_value)) {
                            if ($selected_value == $select_key) {
                                $selectedoption = ' selected="selected"';
                            }
                        }
                        $tdfieldsoutput .= '<option id="' . $select_key . '" value="' . $select_key . '" ' . $selectedoption . ' />' . $option_val . '</option>';
                    }
                    $tdfieldsoutput .= '</select></div>';
                    break;
                // Select Box
                case 'typographyfsize':
                    $tdfieldsoutput .= '<div class="td-select-box">';
                    $tdfieldsoutput .= '<select class="select" name="' . $tdfields['id'] . '">';
                    $selected_value = $this->getOptionConfigure($tdfields['id']);
                    for ($i = 8; $i <= 68; $i++) {
                        $fontsize = $i . 'px';
                        $selectedoption = '';
                        if (isset($selected_value)) {
                            if ($selected_value == $fontsize) {
                                $selectedoption = ' selected="selected"';
                            }
                        }
                        $tdfieldsoutput .= '<option id="' . $fontsize . '" value="' . $fontsize . '" ' . $selectedoption . ' />' . $fontsize . '</option>';
                    }
                    $tdfieldsoutput .= '</select></div>';
                    break;
                // Basic textarea lang with mce
                case 'textarea':
                    $getsavevalue = '';
                    $langfields.= $tdfields['id'];

                    if (isset($tdfields['lang']) && $tdfields['lang'] == true)
                        $getsavevalue = $this->getOptionConfigure($tdfields['id'] . '_' . $this->default_language);
                    else
                        $getsavevalue = $this->getOptionConfigure($tdfields['id']);

                    if (isset($tdfields['tiny_mce']) && $tdfields['tiny_mce'] == true):
                        $tiny_mce = "td-input rte";
                    else:
                        $tiny_mce = 'td-input';
                    endif;

                    if ($getsavevalue != "") {
                        $getsavevalue = stripslashes($getsavevalue);
                    }
                    if (isset($tdfields['lang']) && $tdfields['lang'] == true):
                        foreach ($this->languages as $lang) {
                            $getsavevalue = $this->getOptionConfigure($tdfields['id'] . '_' . $lang['id_lang']);
                            if ($getsavevalue != "") {
                                $getsavevalue = stripslashes($getsavevalue);
                            }
                            $tdfieldsoutput .='<div id="' . $tdfields['id'] . '_' . $lang['id_lang'] . '" style="display: ' . ($lang['id_lang'] == $this->default_language ? 'block' : 'none') . ';float: left;">';
                            $tdfieldsoutput .= '<textarea class="' . $tiny_mce . '" name="' . $tdfields['id'] . '_' . $lang['id_lang'] . '" cols="10" rows="8">' . $getsavevalue . '</textarea>';
                            $tdfieldsoutput .= '</div>';
                        }
                        $tdfieldsoutput .=$this->displayFlags($this->languages, $this->default_language, $langfields, $tdfields['id'], true);
                    else:
                        $tdfieldsoutput .= '<textarea class="' . $tiny_mce . '" name="' . $tdfields['id'] . '" cols="10" rows="8" >' . $getsavevalue . '</textarea>';
                    endif;
                    break;
                // Basic image upload
                case 'upload':
                    $tduploadedimage = $this->getOptionConfigure($tdfields['id']);
                    $values = '';
                    if (isset($tduploadedimage)) {
                        $values = $tduploadedimage;
                    }
                    $tdfieldsoutput .= '<input class="upload td-input" name="' . $tdfields['id'] . '" id="' . $tdfields['id'] . '_upload" value="' . $values . '" />';
                    $tdfieldsoutput .= '<div class="uploadbtn_area"><span class="button uploadbtn" id="' . $tdfields['id'] . '">Upload</span>';
                    $tdfieldsoutput .= '<span class="button resetbtn" id="resimage_' . $tdfields['id'] . '" title="' . $tdfields['id'] . '">Remove</span></div><div class="clear"></div>';
                    if (!empty($tduploadedimage)) {
                        $tdfieldsoutput .= '<div class="up-priview"><a class="td-uploaded-image" href="' . $tduploadedimage . '">';
                        $tdfieldsoutput .= '<img alt="" class="td-upload-image" id="upimage_' . $tdfields['id'] . '" src="' . $tduploadedimage . '" />';
                        $tdfieldsoutput .= '</a></div><div class="clear"></div>';
                    }
                    break;
                case 'color':
                    $getsavevalue = '';
                    $getsavevalue = $this->getOptionConfigure($tdfields['id']);
                    if (isset($getsavevalue)) {
                        $getsavevalue = stripslashes($getsavevalue);
                    }
                    $tdfieldsoutput .= '<div id="' . $tdfields['id'] . '_picker" class="colorSelector"><div style="background-color: ' . $getsavevalue . '"></div></div>';
                    $tdfieldsoutput .= '<input class="td-color" name="' . $tdfields['id'] . '" id="' . $tdfields['id'] . '" type="text" value="' . $getsavevalue . '" />';
                    break;

                case 'typography':
                    $typography = $tdfields['std'];
                    if (isset($typography['face'])) {
                        $getfface = $this->getOptionConfigure($tdfields['id'] . '_face');
                        $tdfieldsoutput .= '<div id="' . $tdfields['id'] . '" ><h3>A quick brown fox jumps over the lazy dog.</h3></div>';
                        $fontfieldid = $tdfields['id'];
                        $tdfieldsoutput .='<script>
                        jQuery(document).ready(function($) {
                        
                    $("#' . $fontfieldid . '_face").change(function(){ 
                    var ' . $fontfieldid . 'fonts = $("option:selected", this).val();
                    var ' . $fontfieldid . 'fontid = ' . $fontfieldid . 'fonts.split(":");
                    if ($("head").find("link#' . $fontfieldid . 'fontlink").length < 1){
                        $("head").append(\'<link id="' . $fontfieldid . 'fontlink" href="" type="text/css" rel="stylesheet"/>\');
                    }
                    $("link#' . $fontfieldid . 'fontlink").attr({href:\'http://fonts.googleapis.com/css?family=\' + ' . $fontfieldid . 'fontid}); 
                    $("style#' . $fontfieldid . 'fontstyle").remove();
                    $("head").append(\'<style id="' . $fontfieldid . 'fontstyle" type="text/css">#' . $fontfieldid . ' h3{ font-family:\' + ' . $fontfieldid . 'fonts + \' !important; }</style>\'); 
                }); 
                
                 var ' . $fontfieldid . 'font=$("#' . $fontfieldid . '_face").val();
                 var ' . $fontfieldid . 'fontid = ' . $fontfieldid . 'font.split(":");
               
                 if ($("head").find(\'link#' . $fontfieldid . 'fontlink\').length < 1){
                        $("head").append(\'<link id="' . $fontfieldid . 'fontlink" href="" type="text/css" rel="stylesheet"/>\');
                    }
                    $("link#' . $fontfieldid . 'fontlink").attr({href:\'http://fonts.googleapis.com/css?family=\' + ' . $fontfieldid . 'fontid}); 
                    $("style#' . $fontfieldid . 'style").remove();
                    $("head").append(\'<style id="' . $fontfieldid . 'style" type="text/css">#' . $fontfieldid . ' h3{ font-family:\' + ' . $fontfieldid . 'font + \'; }</style>\');
 });
                         </script>';
                        $tdfieldsoutput .= '<div class="for-body-selected typography-face" original-title="Font family">';

                        $tdfieldsoutput .= '<select class="of-typography of-typography-face select" name="' . $tdfields['id'] . '[face]" id="' . $tdfields['id'] . '_face">';

                        $system_web_font = array(
                            'arial' => 'Arial',
                            'Verdana' => 'Verdana, Geneva',
                            'trebuchet' => 'Trebuchet',
                            'georgia' => 'Georgia',
                            'Helvetica%20Neue' => 'Helvetica Neue',
                            'times' => 'Times New Roman',
                            'tahoma' => 'Tahoma, Geneva',
                            'Telex' => 'Telex',
                            'Droid Sans' => 'Droid Sans',
                            'Convergence' => 'Convergence',
                            'Oswald' => 'Oswald',
                            'News Cycle' => 'News Cycle',
                            'Yanone Kaffeesatz:300' => 'Yanone Kaffeesatz Light',
                            'Yanone Kaffeesatz:200' => 'Yanone Kaffeesatz ExtraLight',
                            'Yanone Kaffeesatz:400' => 'Yanone Kaffeesatz Regular',
                            'Duru Sans' => 'Duru Sans',
                            'Open Sans' => 'Open Sans',
                            'PT Sans Narrow' => 'PT Sans Narrow',
                            'Macondo Swash Caps' => 'Macondo Swash Caps',
                            'Telex' => 'Telex',
                            'Sirin Stencil' => 'Sirin Stencil',
                            'Actor' => 'Actor',
                            'Iceberg' => 'Iceberg',
                            'Ropa Sans' => 'Ropa Sans',
                            'Amethysta' => 'Amethysta',
                            'Alegreya' => 'Alegreya',
                            'Germania One' => 'Germania One',
                            'Gudea' => 'Gudea',
                            'Trochut' => 'Trochut',
                            'Ruluko' => 'Ruluko',
                            'Alegreya' => 'Alegreya',
                            'Questrial' => 'Questrial',
                            'Armata' => 'Armata',
                            'PT Sans' => 'PT Sans'
                        );
                        $json = file_get_contents('https://www.googleapis.com/webfonts/v1/webfonts?key=AIzaSyAToyXLB8uHcAgbwUkYIc94FX26pN-7R3M', true);
                        $decode = json_decode($json, true);
                        $google_web_fonts = array();
                        //print_r($json);
                        foreach ($decode['items'] as $key => $value) {
                            $fontsfamily = $decode['items'][$key]['family'];
                            $fontsvariants = $decode['items'][$key]['variants'];
                            $fontfamily_replace = str_replace(' ', '+', $fontsfamily);
                            $google_web_fonts[$fontfamily_replace] = $fontsfamily;
                        }
                        if (isset($tdfields['section']) && $tdfields['section'] == 'gfonts') {
                            $webfont = $google_web_fonts;
                        } elseif (isset($tdfields['section']) && $tdfields['section'] == 'sfonts') {
                            $webfont = $system_web_font;
                        }
                        $tdfieldsoutput .= '<option value="">DEFAULT</option>';
                        /* PIXELSAFARI AUSKOMMENTIERT */
                        /*foreach ($webfont as $key => $fontfamily) {

                            $selected_gval = '';
                            $selected_value = '';
                            $idfont = trim($key);
                            if (!empty($getfface)) {
                                if (isset($tdfields['section']) && $tdfields['section'] == 'gfonts') {
                                    if (trim($getfface) == $fontfamily) {
                                        $selected_gval = 'selected="selected"';
                                    }
                                } elseif (isset($tdfields['section']) && $tdfields['section'] == 'sfonts') {
                                    if (trim($getfface) == $idfont) {
                                        $selected_value = 'selected="selected"';
                                    }
                                }
                            } else {
                                if (isset($tdfields['section']) && $tdfields['section'] == 'gfonts') {
                                    if (trim($typography['face']) == $fontfamily) {
                                        $selected_gval = 'selected="selected"';
                                    }
                                } elseif (isset($tdfields['section']) && $tdfields['section'] == 'sfonts') {
                                    if (trim($typography['face']) == $idfont) {
                                        $selected_value = 'selected="selected"';
                                    }
                                }
                            }



                            if (isset($tdfields['section']) && $tdfields['section'] == 'gfonts') {

                                $tdfieldsoutput .= '<option value="' . $fontfamily . '" ' . $selected_gval . '>' . $fontfamily . '</option>';
                            } elseif (isset($tdfields['section']) && $tdfields['section'] == 'sfonts') {
                                $tdfieldsoutput .= '<option value="' . $key . '" ' . $selected_value . '>' . $fontfamily . '</option>';
                            }
                        }*/
                        $tdfieldsoutput .= '</select>';
                        $tdfieldsoutput .= '</div>';
                    }
                    if (isset($typography['color'])) {
                        $selected_value = '';
                        $getfcolor = $this->getOptionConfigure($tdfields['id'] . '_color');
                        if (isset($getfcolor)) {
                            $selected_value = $getfcolor;
                        } else {
                            $selected_value = $typography['color'];
                        }
                        $tdfieldsoutput .= '<div id="' . $tdfields['id'] . '_color_picker" class="colorSelector"><div style="background-color: ' . $selected_value . '"></div></div>';
                        $tdfieldsoutput .= '<input class="td-color of-typography of-typography-color"  name="' . $tdfields['id'] . '[color]" id="' . $tdfields['id'] . '_color" type="text" value="' . $selected_value . '" />';
                    }
                    if (isset($typography['size'])) {
                        $getfsize = $this->getOptionConfigure($tdfields['id'] . '_size');
                        //  print_r($getfsize);
                        $tdfieldsoutput .= '<select class="of-typography of-typography-size" id="' . $tdfields['id'] . '_size" name="' . $tdfields['id'] . '_size">';
                        for ($i = 8; $i <= 40; $i++) {
                            $size = $i . 'px';
                            if ($getfsize != '') {
                                if ($getfsize == $size) {
                                    $selected_value = 'selected="selected"';
                                } else {
                                    $selected_value = '';
                                }
                            } else {
                                if ($tdfields['std'] == $size) {
                                    $selected_value = ' selected="selected"';
                                } else {
                                    $selected_value = '';
                                }
                            }


                            $tdfieldsoutput .='<option value="' . $size . '" ' . $selected_value . ' >' . $size . '</option>';
                        }

                        $tdfieldsoutput .= '</select>';
                    }
                    break;
                case 'images':
                    $i = 0;
                    $get_std = $this->getOptionConfigure($tdfields['id']);
                    foreach ($tdfields['options'] as $key => $option_val) {
                        $i++;
                        $selected_value = '';
                        if (!empty($get_std)) {
                            if ($get_std == $key) {
                                $selected_value = 'add-radio-image';
                            } else {
                                $selected_value = '';
                            }
                        }
                        $tdfieldsoutput .= '<span><input type="radio" id="image-radio-box-' . $tdfields['id'] . $i . '" class="checkbox td-radio-box-image-radio" value="' . $key . '" name="' . $tdfields['id'] . '" ' . $selected_value . ' />';
                        $tdfieldsoutput .= '<div class="td-radio-image-label">' . $key . '</div>';
                        $tdfieldsoutput .= '<img src="' . $option_val . '" alt="" class="td-radio-box-image ' . $selected_value . '" onClick="document.getElementById(\'image-radio-box-' . $tdfields['id'] . $i . '\').checked = true;" /></span>';
                    }

                    break;
                case 'heading':
                    if ($count >= 2) {
                        $tdfieldsoutput .= '</div>';
                    }
                    $leftlink = str_replace(' ', '', strtolower($tdfields['name']));
                    $leftlinkid = "td-taboption-" . $leftlink;
                    $leftlinks .= '<li class="' . $leftlink . ' "><a  data-toggle="tab" title="' . $tdfields['name'] . '" href="#' . $leftlinkid . '">' . $tdfields['name'] . '</a></li>';
                    $tdfieldsoutput .= '<div class="td-tab-panel" id="' . $leftlinkid . '"><h4>' . $tdfields['name'] . '</h4>';
                    break;
                case 'iphonebutton':
                    $get_std = $this->getOptionConfigure($tdfields['id']);
                    $checked = '';

                    if ($get_std != '') {

                        if ($get_std == 'enable') {
                            $checked = ' checked';
                        }
                    } else {

                        if ($tdfields['std'] == 'enable') {
                            $checked = ' checked';
                        }
                    }
                    $anaselect = ($get_std == "enable") ? "selected" : ' ';
                    $disselet = ($get_std == "disable") ? "selected" : ' ';

                    $tdfieldsoutput .='<p class="field switch">
                            <input type="radio" id="radio' . $tdfields['button_id'][0] . '" name="' . $tdfields['id'] . '" value="enable" ' . $checked . ' />
                            <input type="radio" id="radio' . $tdfields['button_id'][1] . '" name="' . $tdfields['id'] . '" value="disable" />
                            
                            <label for="radio' . $tdfields['button_id'][0] . '" class="cb-enable ' . $anaselect . '"><span>' . $tdfields['options'][0] . '</span></label>
                            <label for="radio' . $tdfields['button_id'][1] . '" class="cb-disable ' . $disselet . '"><span>' . $tdfields['options'][1] . '</span></label>
                        </p>';
                    break;
                case 'tiles':
                    $i = 0;
                    $get_std = $this->getOptionConfigure($tdfields['id']);
                    foreach ($tdfields['options'] as $key => $option_val) {
                        $i++;

                        $selected_value = '';
                        if (isset($get_std)) {
                            if ($get_std == $option_val) {
                                $selected_value = 'td-radio-tile-selected';
                            }
                        }
                        $tdfieldsoutput .= '<span><input type="radio" id="td-radio-tile-' . $tdfields['id'] . $i . '" class="checkbox td-radio-tile-radio" value="' . $option_val . '" name="' . $tdfields['id'] . '" />';
                        $tdfieldsoutput .= '<div class="td-radio-tile-img ' . $selected_value . '" onClick="document.getElementById(\'td-radio-tile-' . $tdfields['id'] . $i . '\').checked = true;"><img width="50" height="50" alt="" src="' . $option_val . '" ></div></span>';
                    }

                    break;
            }
            if ($tdfields['type'] != 'heading') {
                if (!isset($tdfields['desc'])) {
                    $explain_value = '';
                } else {
                    $explain_value = '<div class="explain">' . $tdfields['desc'] . '</div>';
                }
                $tdfieldsoutput .= '</div>' . $explain_value;
                $tdfieldsoutput .= '<div class="clear"> </div></div></div>';
            }
        }
        $tdfieldsoutput .= '</div>';

        return array($leftlinks, $tdfieldsoutput);
    }

    public function getBgPatern() {
        $getBFpattarn = array();
        if (is_dir($this->patternsDIR)) {
            if ($bfpaterndir = opendir($this->patternsDIR)) {
                while (( $bgpatern_name = readdir($bfpaterndir)) !== false) {
                    if (stristr($bgpatern_name, ".png") !== false || stristr($bgpatern_name, ".gif") !== false || stristr($bgpatern_name, ".jpg") !== false) {
                        $getBFpattarn[] = $this->patternsURL . $bgpatern_name;
                    }
                }
            }
        }
        $this->pattern = $getBFpattarn;
    }

    public function installDefaultValue() {
        $tdoptions = $this->tdoptions;
        foreach ($tdoptions as $option_result):
            $getsavevaluevalue = isset($option_result['std']) ? $option_result['std'] : '';
            if (isset($getsavevaluevalue)) {
                if (is_array($getsavevaluevalue)) {
                    foreach ($getsavevaluevalue as $key => $output_value) {
                        Configuration::updateValue($option_result['id'] . "_" . $key, htmlspecialchars($output_value));
                    }
                } else {

                    if (isset($option_result['lang']) && $option_result['lang'] == true) {
                        foreach ($this->languages as $lang) {
                            Configuration::updateValue($option_result['id'] . '_' . $lang['id_lang'], htmlspecialchars($option_result['std']));
                        }
                    } else {
                        if (isset($option_result['id']) && isset($option_result['std']))
                            Configuration::updateValue($option_result['id'], htmlspecialchars($option_result['std']));
                    }
                }
            }

        endforeach;
        return true;
    }

    private function _insertData($insertdata) {
        if (isset($insertdata['td_shopid'])) {
            $shopid = $insertdata['td_shopid'];
        } else {
            $shopid = '';
        }
        if (isset($insertdata['td_shopgroup'])) {
            $shopgroup = $insertdata['td_shopgroup'];
        } else {
            $shopgroup = '';
        }
        //echo $insertdata['td_slider_type'];
        //public static function updateValue($key, $values, $html = false, $id_shop_group = null, $id_shop = null)
        foreach ($insertdata as $id => $data) {
            if (is_array($data)) {
                foreach ($data as $key => $data_value) {
                    Configuration::updateValue($id . "_" . $key, $data_value, true, $shopgroup, $shopid);
                }
            } else {
                Configuration::updateValue($id, htmlspecialchars($data), true, $shopgroup, $shopid);
            }
        }
        $this->successmeg = '<div class="bootstrap">
		<div class="module_confirmation conf confirm alert alert-success">
			The settings have been updated.
		</div>
		</div>';
        return TRUE;
    }

    public function hex_to_rgba($color) {
        $color = str_replace("#", "", $color);
        if (strlen($color) == 3) {
            $r = hexdec(substr($color, 0, 1) . substr($color, 0, 1));
            $g = hexdec(substr($color, 1, 1) . substr($color, 1, 1));
            $b = hexdec(substr($color, 2, 1) . substr($color, 2, 1));
        } else {
            $r = hexdec(substr($color, 0, 2));
            $g = hexdec(substr($color, 2, 2));
            $b = hexdec(substr($color, 4, 2));
        }
        $getrgb = array($r, $g, $b);
        return $getrgb;
    }

    public function adjust_brightness($hex, $adjust) {
        $adjust = max(-255, min(255, $adjust));

        $rgba = $this->hex_to_rgba($hex);

        $r = $rgba[0];
        $g = $rgba[1];
        $b = $rgba[2];

        $r = max(0, min(255, $r + $adjust));
        $g = max(0, min(255, $g + $adjust));
        $b = max(0, min(255, $b + $adjust));

        $r_hex = str_pad(dechex($r), 2, '0', STR_PAD_LEFT);
        $g_hex = str_pad(dechex($g), 2, '0', STR_PAD_LEFT);
        $b_hex = str_pad(dechex($b), 2, '0', STR_PAD_LEFT);

        return '#' . $r_hex . $g_hex . $b_hex;
    }

    public function tdThemeOption() {
        $td_options = array();

        $td_options[] = array("name" => "General Settings",
            "type" => "heading");

      if (Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE') == 1) {
            $count = count($this->idshop);
            if ($count > 1) {
                $td_options[] = array("name" => "Shop Group",
                    "desc" => "Select Shop Group",
                    "id" => $this->tdthemename . "shopgroup",
                    "std" => '',
                    "options" => $this->idshopgroup,
                    "type" => "select");
                $td_options[] = array("name" => "Shop Name",
                    "desc" => "Select Shop Name for save data use to multishop. ",
                    "id" => $this->tdthemename . "shopid",
                    "std" => '',
                    "options" => $this->idshop,
                    "type" => "select");
            }
        }
     $td_options[] = array("name" => 'Individual Menu',
            "desc" => 'Individual Menu Show on top of the page!',
            "id" => $this->tdthemename . 'individual_menu',
            "std" => "enable",
            "button_id" => array(1, 2),
            "options" => array('Enable', 'Disable'),
            "type" => "iphonebutton");

    $td_options[] = array("name" => 'Product Hover effect',
            "desc" => 'If you can use to Product Over effect top or bottom',
            "id" => $this->tdthemename . 'hover_effect',
            "std" => "enable",
            "button_id" => array(3, 4),
            "options" => array('bottom', 'top'),
            "type" => "iphonebutton");

        $td_options[] = array("name" => "Product Default View Mode",
            "desc" => "If you want to change default product view style on product list page.",
            "id" => $this->tdthemename . "proviewstyle",
            "std" => "gridview",
            "type" => "images",
            "options" => array(
                'listview' => $this->backofficImage . 'product_list.png',
                'gridview' => $this->backofficImage . 'row_3.png'
            )
        );

         
          
             $td_options[] = array("name" => 'Product Per Row',
            "desc" => 'Per Row Product View on list of the page..',
            "id" => $this->tdthemename . 'pro_rows',
            "std" => "3",
            "type" => "images",
            "options" => array(
                '2' => $this->backofficImage . 'row_2.png',
                '3' => $this->backofficImage . 'row_3.png',
                '4' => $this->backofficImage . 'row_4.png'
                
            )
                  );
     
           $td_options[] = array("name" => 'Product Page Layout',
            "desc" => 'Product Page Layout Style',
            "id" => $this->tdthemename . 'pro_pageview',
            "std" => "default",
            "type" => "images",
            "options" => array(
                'default' => $this->backofficImage . 'default.png',
                'horizontal' => $this->backofficImage . 'horizontal.png',
                'vertical' => $this->backofficImage . 'vertical.png'
                
            )
                  );
$td_options[] = array("name" => "Menu Options",
            "type" => "innerheading");
  
        $td_options[] = array("sub_name" => "Menu Row Items",
            "desc" => "Mega menu Row Items.",
            "id" => $this->tdthemename . "mrowitem",
            "std" => "4",
            "options"=>array('2'=>'2','3'=>'3','4'=>'4','5'=>'5','6'=>'6'),
            "type" => "select");
    $td_options[] = array("sub_name" => "Menu Speed",
            "desc" => "Mega menu Speed.",
            "id" => $this->tdthemename . "mspeed",
            "std" => "first",
            "options"=>array('first'=>'First','slow'=>'Slow'),
            "type" => "select");
  

     

        $td_options[] = array("name" => "Home Page Block",
            "type" => "heading");
        $td_options[] = array("name" => "Home Page Custom Block",
            "desc" => "Custom HTML Block On Home Page.",
            "id" => $this->tdthemename . 'hcustomb_content',
            "lang" => true,
             "tiny_mce" => true,
            "std" => '<div><div class="home-block custom">
<div class="one_third"><span class="fa fa-mobile-phone">&nbsp;</span>
<h2>Fluid Based Responsive</h2>
<p>Responsive Theme is a flexible foundation with fluid grid system that adapts your website to mobile devices and the desktop or any other viewing environment.</p>
</div>
<div class="one_third"><span class="fa fa-cogs">&nbsp;</span>
<h2>Customization</h2>
<p>Customize theme easily through Admin Settings with number of options such as Background, Google Fonts, Size, Colors, Menu, Banners, and Hover Effects etc.</p>
</div>
<div class="one_third last"><span class="fa fa-comments">&nbsp;</span>
<h2>Support &amp; Updates</h2>
<p>We do care about our customers and we have Support ticket system for our customers to get in touch with us easily any time.</p>
</div>
</div></div>
',
"type" => "textarea");
         $td_options[] = array("name" => "Home Page Banner Block",
            "desc" => "Custom HTML On Home Page.",
            "id" => $this->tdthemename . 'hcusbanner',
            "lang" => true,
             "tiny_mce" => true,
            "std" => '<div><div class="home-block">
<div class="one_third">
<div class="img_center"><img alt="" src="'.$this->themeImage.'block1.png"></div>
</div>
<div class="one_third">
<div class="img_center"><img alt="" src="'.$this->themeImage.'block2.png"></div>
</div>
<div class="one_third last">
<div class="img_center"><img alt="" src="'.$this->themeImage.'block3.png"></div>
</div>
</div></div>
<div style="clear: both;">&nbsp;</div>',
"type" => "textarea");
        
        
        
      $td_options[] = array("name" => "Product Page Block",
            "type" => "heading");
      
        $td_options[] = array("name" => "Custom HTML BLOCK",
            "desc" => "Custom HTML Block On Right Sidebar of Product Page.",
            "id" => $this->tdthemename . 'pro_customblock',
            "lang" => true,
             "tiny_mce" => true,
            "std" => '<h3>  Customized Area</h3>
<div class="best_theme">
  <h2>Looking for the best theme?</h2>
<div class="theme_image"><img alt="" src="'.$this->themeImage.'banner.jpg"></div>
<a href="#" title="best theme" class="button"><span>Click to know more</span></a>
</div>
',
 "type" => "textarea");
     $td_options[] = array("name" => "Custom HTML BLOCK",
            "desc" => "Custom HTML Block On Bottom of the Product Page.",
            "id" => $this->tdthemename . 'pro_bcustomblock',
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<h2>Custom Block Here</h2>
<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Nam cursus. Morbi ut mi. Nullam enim leo, egestas id, condimentum at, laoreet mattis, massa. Sed eleifend nonummy diam. Praesent mauris ante, elementum et, bibendum at, posuere sit amet, nibh. Duis tincidunt lectus quis dui viverra vestibulum. Suspendisse vulputate aliquam dui.Nulla elementum dui ut augue. Aliquam vehicula mi at mauris. Maecenas placerat, nisl at consequat rhoncus, sem nunc gravida justo, quis eleifend arcu velit quis lacus.</p>
',
 "type" => "textarea"); 
  $td_options[] = array("name" => "Blog Options",
            "type" => "heading");
       $td_options[] = array("name" => "Blog Per Page",
            "desc" => "Number of post show in blog per page.",
            "id" => $this->tdthemename . 'blogperpage',
            "std" => '5',
            "type" => "text");
  
         
         $td_options[] = array("name" => "Number Of Recent Post",
            "desc" => "Number of recent post show in blog sidebar.",
            "id" => $this->tdthemename . 'numofrepost',
            "std" => '10',
            "type" => "text");
        
         $td_options[] = array("name" => "Number OF Comments",
            "desc" => "Number of comments show in blog sidebar.",
            "id" => $this->tdthemename . 'numofcomments',
            "std" => '5',
            "type" => "text");


        $td_options[] = array("name" => "Styling Options",
            "type" => "heading");

        $td_options[] = array("name" => "Primary Color ",
            "desc" => "Set the theme color",
            "id" =>$this->tdthemename . "themecolor",
            "std" => "#03997E",
            "type" => "color");

        $td_options[] = array("name" => "Second Color",
            "desc" => "Set the Second color for your theme.",
            "id" =>$this->tdthemename . "secondcolor",
            "std" => "#F9F9F9",
            "type" => "color");
        
         $td_options[] = array("name" => "Menu",
            "type" => "innerheading");
         
            $td_options[] = array("name" => "Menu Background Color",
            "desc" => "Set the sidebar color for your theme.",
            "id" =>$this->tdthemename . "menu_bgcolor",
            "std" => "#F9F9F9",
            "type" => "color");
     
           
          $td_options[] = array("name" => "Sidebar",
            "type" => "innerheading");
        $td_options[] = array("name" => "Sidebar Background Color",
            "desc" => "Set the sidebar color for your theme.",
            "id" =>$this->tdthemename . "sidebar_bgcolor",
            "std" => "",
            "type" => "color");
           $td_options[] = array("name" => "Sidebar Fonts color",
            "desc" => "Set the sidebar fonts color for your theme.",
            "id" =>$this->tdthemename . "sidebar_fontsc",
            "std" => "#2E2E2E",
            "type" => "color");
           
        
           $td_options[] = array("name" => "Product Grid View",
            "type" => "innerheading");
        
            $td_options[] = array("name" => 'Product grid box border',
            "desc" => 'If you want show grid view product with border.',
            "id" => $this->tdthemename . 'gridboxborder',
            "std" => "disable",
            "button_id" => array(7, 8),
            "options" => array('Yes', 'No'),
            "type" => "iphonebutton");
        
           $td_options[] = array("name" => "Product grid box color",
            "desc" => "Set the Product Grid View box color for your theme.",
            "id" =>$this->tdthemename . "gridboxcolor",
            "std" => "#D8D8D8",
            "type" => "color");
           $td_options[] = array("name" => "Product gird box hover color",
            "desc" => "Set the Product Grid View box Hover color for your theme.",
            "id" =>$this->tdthemename . "gridboxhover",
            "std" => "",
            "type" => "color");
            $td_options[] = array("name" => "Product gird box font color",
            "desc" => "Set the Product Grid View box Fonts color for your theme.",
            "id" =>$this->tdthemename . "gridboxfontc",
            "std" => "#FFFFFF",
            "type" => "color");
            
         $td_options[] = array("name" => "Product List View",
            "type" => "innerheading");
        
            $td_options[] = array("name" => 'Product list box border',
            "desc" => 'If you want show list view product with border.',
            "id" => $this->tdthemename . 'listboxborder',
            "std" => "disable",
            "button_id" => array(9, 10),
            "options" => array('Yes', 'No'),
            "type" => "iphonebutton");
            $td_options[] = array("name" => "Product list active color",
            "desc" => "Set the List View active color for your theme.",
            "id" =>$this->tdthemename . "listactivecolor",
            "std" => "",
            "type" => "color");
            
                    
          $td_options[] = array("name" => "Footer",
            "type" => "innerheading");
        $td_options[] = array("name" => "Footer Background color",
            "desc" => "Set the Footer Background color for your theme.",
            "id" =>$this->tdthemename . "foo_bgcolor",
            "std" => "#F9F9F9",
            "type" => "color");
           $td_options[] = array("name" => "Footer title fonts color",
            "desc" => "Set the Footer title fonts  color for your theme.",
            "id" =>$this->tdthemename . "foo_titlecolor",
            "std" => "",
            "type" => "color");
                 $td_options[] = array("name" => "Footer text font color",
            "desc" => "Set the Footer text font color for your theme.",
            "id" =>$this->tdthemename . "foo_textcolor",
            "std" => "#383838",
            "type" => "color");
           $td_options[] = array("name" => "Footer link font color ",
            "desc" => "Set the Footer link font color for your theme.",
            "id" =>$this->tdthemename . "foo_linkcolor",
            "std" => "#383838",
            "type" => "color");

           
        $td_options[] = array("name" => "Body background",
            "type" => "innerheading");
        
        $td_options[] = array("name" => "Body Background Color",
            "desc" => "Set the Background color for your theme.",
            "id" => $this->tdthemename . "body_bg_color",
            "std" => "#ffffff",
            "type" => "color");

   $td_options[] = array("name" => 'Body Background Pattern',
            "desc" => 'If you want to use Backgrond pattern',
            "id" => $this->tdthemename . 'enabody_bg',
            "std" => "disable",
            "button_id" => array(11, 12),
            "options" => array('Enable', 'Disable'),
            "type" => "iphonebutton");

        $td_options[] = array("name" => "Background Pattern",
            "id" =>$this->tdthemename . "body_bg",
            "std" => $this->patternsURL . "pattern3.png",
            "type" => "tiles",
            "options" => $this->pattern,
        );


        $td_options[] = array("name" => "Custom Background",
            "desc" => "Upload a custom background image for your theme. This will override the option above. This is only for the main background pattern.",
            "id" => $this->tdthemename . "body_bg_custom",
            "std" => "",
            "mod" => "min",
            "type" => "upload");

        $td_options[] = array("name" => "background-attachment",
            "desc" => "You can define additional shorthand properties for the background. ",
            "id" => $this->tdthemename . "bgattachment",
            "std" => "scroll",
            "options"=>array('scroll'=>'scroll','fixed'=>'fixed','inherit'=>'inherit'),
            "type" => "select");
         $td_options[] = array("name" => "background-repeat",
            "desc" => "You can define additional shorthand properties for the background.",
            "id" => $this->tdthemename . "bgrepeat",
            "std" => "repeat",
            "options"=>array('repeat'=>'repeat','repeat-x'=>'repeat-x','repeat-y'=>'repeat-y','no-repeat'=>'no-repeat','inherit'=>'inherit'),
            "type" => "select");
  $td_options[] = array("sub_name" => "background-position",
            "desc" => "You can define additional shorthand properties for the background.",
            "id" => $this->tdthemename . "bgposition",
            "std" => "0 0",
            "type" => "text");
    
    

        $td_options[] = array("name" => "Custom Style",
            "desc" => "Put your custom style here.",
            "id" => $this->tdthemename . "custom_style",
            "std" => "",
            "type" => "textarea");
 

        $td_options[] = array("name" => "Typography",
            "type" => "heading");
        
        
        
       /* $td_options[] = array("name" => "Heading Font Style",
            "desc" => "You can change menu & heading font style.",
            "id" => $this->tdthemename . "heading_font",
            "std" => array('face' => '','color' => ''),
            "section" => "google", //googoogle
            "type" => "typography");*/
        
        
          /* $td_options[] = array("name" => 'Social Footer Link',
            "type" => "head_block");
           */
           $td_options[] = array("name" => "Menu Title Font Style",
            "desc" => "You can change menu font style.",
            "id" => $this->tdthemename . "menu_title",
            "std" => array('face' => '','color' => ''),
            "section" => "google", //googoogle
            "type" => "typography");

        $td_options[] = array("name" => "Sidebar title Font Style",
            "desc" => "You can change sidebar font style.",
            "id" => $this->tdthemename . "sidebar_title",
            "std" => array('face' => 'open_sansregular','color' => ''),
            "section" => "google", //googoogle
            "type" => "typography");

        $td_options[] = array("name" => "Body Font Style",
            "desc" => "You can change body font style.",
            "id" => $this->tdthemename . "body_font",
            "std" => array('face' => '','color' => ''),
            "section" => "system",
            "type" => "typography");

       



        $td_options[] = array("name" => "Social Options",
            "type" => "heading");
     
           $td_options[] = array("name" => 'Facebook Like Box',
            "desc" => 'If you want to use facebook like box footer of the page',
            "id" => $this->tdthemename . 'facebook_likebox',
            "std" => "enable",
            "button_id" => array(13, 14),
            "options" => array('Enable', 'Disable'),
            "type" => "iphonebutton");

        $td_options[] = array("sub_name" => 'Facebook Page URL',
            "desc" => "Enter your facebook page url.",
            "id" => $this->tdthemename . "fb_page_url",
            "std" => "http://www.facebook.com/themesdeveloper",
            "type" => "block_text");
        
        
        $td_options[] = array("sub_name" => 'Facebook Page ID',
            "desc" => "Enter your facebook Fun page id.",
            "id" => $this->tdthemename . "fb_page_id",
            "std" => "",
            "type" => "block_text");
        
        
        $td_options[] = array("name" => 'Social Footer Link',
            "type" => "head_block");
        
          $td_options[] = array("sub_name" => 'Twitter URL',
            "desc" => "Enter your Twitter url.",
            "id" => $this->tdthemename . "twitter_url",
            "std" => "#",
            "type" => "block_text");
        $td_options[] = array("sub_name" => 'Facebook URL',
            "desc" => "Enter your facebook url.",
            "id" => $this->tdthemename . "facebook_url",
            "std" => "#",
            "type" => "block_text");

      
        $td_options[] = array("sub_name" => 'Pinterest',
            "desc" => " Enter your Pinterest url.",
            "id" => $this->tdthemename . "pinterest_url",
            "std" => "#",
            "type" => "block_text");
        
        $td_options[] = array("sub_name" => 'Link IN',
            "desc" => "Enter your Link IN ID",
            "id" => $this->tdthemename . "link_in",
            "std" => "#",
            "type" => "block_text");
         $td_options[] = array("sub_name" => 'Google Plus',
            "desc" => "Enter your Google Plus ID",
            "id" => $this->tdthemename . "googleplus",
            "std" => "#",
            "type" => "block_text");
$td_options[] = array("name" => "Social Share Block",
            "desc" => "Social Share Block On Right Sidebar of Product Page.",
            "id" => $this->tdthemename . 'pro_shareright',
            "std" => '<!-- AddThis Button BEGIN -->
<div class="addthis_toolbox addthis_default_style ">
<a class="addthis_button_preferred_1"></a>
<a class="addthis_button_preferred_2"></a>
<a class="addthis_button_preferred_3"></a>
<a class="addthis_button_preferred_4"></a>
<a class="addthis_button_compact"></a>
<a class="addthis_counter addthis_bubble_style"></a>
</div>
<script type="text/javascript">var addthis_config = {"data_track_addressbar":false};</script>
<script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-5243d83906affd99"></script>
<!-- AddThis Button END -->',
 "type" => "textarea"); 
     $td_options[] = array("name" => "Custom Block",
            "type" => "heading");

    $td_options[] = array("name" => 'Custom HTML Block',
            "desc" => "Custom HTML Block left sidebar of the page ",
            "id" => $this->tdthemename . "left_customh",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<div class="block">
<div class="block-title"><strong><span>Custom Left Block</span></strong></div>
<div class="block-content">
<p>Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500s</p>
</div>
</div>',
            "type" => "textarea");


        $td_options[] = array("name" => "Footer Options",
            "type" => "heading");

        $td_options[] = array("name" => 'Free Shipping Block',
            "desc" => "You can use this text box for showing text footer of the page ",
            "id" => $this->tdthemename . "free_shipping",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<h2>Free Shipping on order of $200</h2>
                      <div class="truck-img">&nbsp;</div>
               ',
            "type" => "textarea");
        
        
        
        $td_options[] = array("name" => 'Contact Info',
            "desc" => "You can use contact info for showing footer of the page ",
            "id" => $this->tdthemename . "contact_info",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<h1>CONTACT US</h1>
<p class="add">Metro STORE, 101, MM Street, MG Road, Old walley5655.</p>
<p>+1 234 6874258</p>
<p>info@metros.com</p>',
            "type" => "textarea");
        
        
        
           $td_options[] = array("name" => 'Additional Links',
            "desc" => "You can use links or custom HTML here for showing footer of the page ",
            "id" => $this->tdthemename . "addi_offerlinks",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<h1>METROS OFFERS</h1>
<ul>
<li><a href="#">Specials</a></li>
<li><a href="#">New products</a></li>
<li><a href="#">Top sellers</a></li>
<li><a href="#">Our stores</a></li>
<li><a href="#">Contact us</a></li>
</ul>',
            "type" => "textarea");
           
        $td_options[] = array("name" => 'Additional Links',
            "desc" => "You can use links or custom HTML here for showing footer of the page ",
            "id" => $this->tdthemename . "additional_links",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '<h1>HELP LINKS</h1>
<ul>
<li><a href="#">About Us</a></li>
<li><a href="#">Customer Service</a></li>
<li><a href="#">Privacy Policy</a></li>
<li><a href="#">Advance Search</a></li>
<li><a href="#">Orders and Returns</a></li>
</ul>',
            "type" => "textarea");
$td_options[] = array("name" => 'Footer Custom Block',
            "desc" => "If facebook Like box Not enable then show this block on footer of the page.",
            "id" => $this->tdthemename . "footer_cblock",
            "lang" => true,
            "tiny_mce" => true,
            "std" => '',
            "type" => "textarea");

        $td_options[] = array("name" => "Copyright info",
            "desc" => "Add your Copyright or some other notice.",
            "id" => $this->tdthemename . "copyright",
            "tiny_mce" => true,
            "std" => " &copy; 2012. All rights reserved. Metros, Inc.",
            "type" => "textarea");

        $this->tdoptions = $td_options;
    } 

    public function styleCustom() {
         if (Configuration::get('td_menu_title_face')) {
            $td_menu_title_face = str_replace(" ", "+", Configuration::get('td_menu_title_face'));
            $this->context->controller->addCSS('//fonts.googleapis.com/css?family=' . $td_menu_title_face . ':400,300,700,normal', 'all');
        }
          if (Configuration::get('td_sidebar_title_face')) {
            $td_sidebar_title_face = str_replace(" ", "+", Configuration::get('td_sidebar_title_face'));
            $this->context->controller->addCSS('//fonts.googleapis.com/css?family=' . $td_sidebar_title_face . ':400,300,700,normal', 'all');
        }
        if (Configuration::get('td_body_font_face') && (Configuration::get('td_body_font_face') != "arial") && (Configuration::get('td_body_font_face') !=  "Verdana") && (Configuration::get('td_body_font_face') != "trebuchet") && (Configuration::get('td_body_font_face') !=  "trebuchet") && (Configuration::get('td_body_font_face')!= "georgia") && (Configuration::get('td_body_font_face')!= "times") && (Configuration::get('td_body_font_face') != "tahoma")) {
            $td_body_font_face = str_replace(" ", "+", Configuration::get('td_body_font_face'));
            $this->context->controller->addCSS('//fonts.googleapis.com/css?family=' . $td_body_font_face . ':400,300,700,normal', 'all');
        }

        $page_name = Dispatcher::getInstance()->getController();

               
        $this->context->controller->addCSS(($this->themeCSSURL) . 'styles.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'responsive.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'jquery.bxslider.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'carousel.css', 'all');        
        $this->context->controller->addCSS(($this->themeCSSURL) . 'nav.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'font-awesome.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'font-awesome.min.css', 'all');
        $this->context->controller->addCSS(($this->themeCSSURL) . 'mobile.css', 'all');

        
        
        $this->context->controller->addJS(($this->themeJSURL) . 'js.js');
        $this->context->controller->addJS(($this->themeJSURL) . 'jquery.easing.1.3.js');
        $this->context->controller->addJS(($this->themeJSURL) . 'camera.min.js');
        //$this->context->controller->addJS(($this->themeJSURL) . 'jquery.touchify.js');
        //$this->context->controller->addJS(($this->themeJSURL) . 'jquery.ui.carousel.js');
       // $this->context->controller->addJS(($this->themeJSURL) . 'jquery-ui-touchCarousel.js');
        $this->context->controller->addJS(($this->themeJSURL) . 'jquery.flexslider.js');
        $this->context->controller->addJS(($this->themeJSURL) . 'jquery.mousewheel-3.0.4.pack.js');
        
        
        $this->context->controller->addJS(($this->themeJSURL) . 'menu/jquery.hoverIntent.minified.js');
        $this->context->controller->addJS(($this->themeJSURL) . 'menu/jquery.dcmegamenu.1.3.3.js');
   
        if (($page_name == "index") || ($page_name == "product") || ($page_name == "order")) {
            $this->context->controller->addCSS(($this->themeCSSURL) . 'flexslider.css', 'all');
             $this->context->controller->addCSS(($this->themeCSSURL) . 'banner.css', 'all');
        }
        
        if ($page_name == "product") {
            $this->context->controller->addCSS(($this->themeCSSURL) . 'cloud-zoom.css', 'all');
            $this->context->controller->addJS(($this->themeJSURL) . 'cloud-zoom.1.0.2.min.js');
        }

        if ((Configuration::get('td_skin') == 'dark')) {
            
        }
        /* Panel main color */
        $custom_styles = "
            .cat_desc{
               color:#000 ;
        }
        ";


        /* Panel Custom CSS */
        $custom_style = Configuration::get('td_custom_style');

        if (isset($custom_style)) {
            $custom_styles .= html_entity_decode(stripslashes($custom_style));
        }

        $style_file = fopen(dirname(__FILE__) . '/style_custom.css', 'w');

        /* if ($style_file === false)
          return 0; */

        $saved = fwrite($style_file, $custom_styles);
        fclose($style_file);

        $this->context->controller->addCSS(__PS_BASE_URI__ . 'modules/tdpsthemeoptionpanel/style_custom.css', 'all');
        return true;
    }

}
