<?php

/**

 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)

 *

 * @author    VEKIA https://www.prestashop.com/forums/user/132608-vekia/

 * @copyright 2010-2015 VEKIA

 * @license   This program is not free software and you can't resell and redistribute it

 *

 * CONTACT WITH DEVELOPER http://mypresta.eu

 * support@mypresta.eu

 */



require_once _PS_MODULE_DIR_.'productpopup/models/ppopup.php';



class Productpopup extends Module

{

	public function __construct()

	{

		$this->name = 'productpopup';

		$this->tab = 'front_office_features';

		$this->version = '2.3.1';

		$this->author = 'MyPresta.eu';

		$this->module_key = 'c76ce0ec6637e3d469bfc9afc05f2f06';

		$this->displayName = $this->l('Product modal popup');

		$this->description = $this->l('Create modal popup window for product pages');

		parent::__construct();

	}





	public function install()

	{

		$sql = array();

		$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ppopup` (

                  `id_ppopup` int(10) unsigned NOT NULL AUTO_INCREMENT,

                  `id_product` INT( 11 ) UNSIGNED NOT NULL,

                  `active` INT( 1 ) NOT NULL,

                  `opacity` VARCHAR(5)  NOT NULL,

                  `bgcolor` VARCHAR(10),

                  `border_bg` VARCHAR(10),

                  `border` INT(10),

                  `popup_bg` VARCHAR(10),

                  `width` VARCHAR(10),

                  `height` VARCHAR(10),

                  `unlogged` VARCHAR(5),

                  `redisplay` VARCHAR(20),

                  `testmode` INT(1) NOT NULL,

                  `tablet_width` VARCHAR(7) NULL DEFAULT "300",

                  `tablet_height` VARCHAR(7) NULL DEFAULT "150",

                  `mobile_width` VARCHAR(7) NULL DEFAULT "90",

                  `mobile_height` VARCHAR (7) NULL DEFAULT "150",

                  PRIMARY KEY (`id_ppopup`),

                  UNIQUE  `id_ppopup_unique` (  `id_ppopup` )

                 ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';



		$sql[] = 'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'ppopup_lang` (

                  `id_ppopup` int(10) unsigned NOT NULL,

                  `id_lang` int(10) unsigned NOT NULL,

                  `body` TEXT NULL,

                  `name` TEXT NULL,

				  `tablet` TEXT NULL,

                  `mobile` TEXT NULL

                 ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8';



		if ($this->psversion() == 5 || $this->psversion() == 6)

		{

			if (!parent::install() or !Configuration::updateValue('update_'.$this->name, '0') or !$this->registerHook('BackOfficeFooter') or !$this->registerHook('header') or !$this->registerHook('footer') or !$this->registerHook('displayAdminProductsExtra') or !$this->runSql($sql))

				return false;

		}

		return true;

	}



	public function psversion()

	{

		$version = _PS_VERSION_;

		$exp = explode('.', $version);

		return $exp[1];

	}



	public function runSql($sql)

	{

		foreach ($sql as $s)

		{

			if (!Db::getInstance()->Execute($s))

				return false;

		}

		return true;

	}



	public function getproductblocks()

	{

		$query = 'SELECT * FROM `'._DB_PREFIX_.'ppopup` AS a LEFT JOIN `'._DB_PREFIX_.'ppopup_lang` AS b ON a.id_ppopup = b.id_ppopup';

		return Db::getInstance()->ExecuteS($query);

	}



	public function hookHeader($params)

	{

		$this->context->controller->addJS(($this->_path).'js/jquery.joverlay.min.js');

		$this->context->controller->addCSS(($this->_path).'css/productpopup.css');

	}



	public function hookFooter($params)

	{

		if (Tools::getValue('controller', 'false') != 'false' && Tools::getValue('id_product', 'false') != 'false')

		{

			$ppopup = new ppopup();

			$ppopups = '';

			if ($ppopup::loadByIdProductActive((int)Tools::getValue('id_product')) != null)

			{

				foreach ($ppopup::loadByIdProductActive((int)Tools::getValue('id_product')) as $value)

				{

					if ($value->testmode == 1)

					{

						if ($value->unlogged == 1)

						{

							if (is_int($this->context->customer->id))

								$ppopups .= '$().jOverlay({url:\''._MODULE_DIR_.'productpopup/popup.php?id_ppopup='.$value->id_ppopup.'\', color:\'#'.$value->bgcolor.'\', opacity:'.$value->opacity.'}); ';



						}

						else

							$ppopups .= '$().jOverlay({url:\''._MODULE_DIR_.'productpopup/popup.php?id_ppopup='.$value->id_ppopup.'\', color:\'#'.$value->bgcolor.'\', opacity:'.$value->opacity.'}); ';



					}

					else

					{

						if (!isset($_COOKIE['popup_'.Tools::getValue('id_product').'_'.$value->id_ppopup]))

						{

							if ($value->unlogged == 1)

							{

								if (is_int($this->context->customer->id))

								{

									$ppopups .= '$().jOverlay({url:\''._MODULE_DIR_.'productpopup/popup.php?id_ppopup='.$value->id_ppopup.'\', color:\'#'.$value->bgcolor.'\', opacity:'.$value->opacity.'}); ';

									setcookie('popup_'.Tools::getValue('id_product').'_'.$value->id_ppopup, '1', time() + $value->redisplay * 60 * 60 * 24);

								}

							}

							else

							{

								$ppopups .= '$().jOverlay({url:\''._MODULE_DIR_.'productpopup/popup.php?id_ppopup='.$value->id_ppopup.'\', color:\'#'.$value->bgcolor.'\', opacity:'.$value->opacity.'}); ';

								setcookie('popup_'.Tools::getValue('id_product').'_'.$value->id_ppopup, '1', time() + $value->redisplay * 60 * 60 * 24);

							}

						}

					}

				}

				$ppopupblocks = '

                <script type="text/javascript">

        		$(document).ready(function(){

                    '.$ppopups.'

        		});

        		</script>';

			}

			else

				$ppopupblocks = '';



			$this->context->smarty->assign(array('id_lang' => $this->context->cookie->id_lang, 'ppopupblocks' => $ppopupblocks));

			return $this->display(__file__, 'views/templates/front/footer.tpl');

		}

	}



	public function hookDisplayAdminProductsExtra($params)

	{

		if (Tools::getValue('action', 'false') != 'false')

		{

			if (Tools::getValue('action') == 'addnewpopup')

			{

				$ppopup = new ppopup();

				$ppopup->id_product = Tools::getValue('id_product');

				$ppopup->active = '0';

				$ppopup->bgcolor = Tools::getValue('popup_overlay_bg');

				$ppopup->opacity = Tools::getValue('popup_overlay_opacity');

				$ppopup->border = Tools::getValue('popup_border_width');

				$ppopup->border_bg = Tools::getValue('popup_border_color');

				$ppopup->popup_bg = Tools::getValue('ppopup_bg');

				$ppopup->width = Tools::getValue('popup_width');

				$ppopup->height = Tools::getValue('popup_height');

				$ppopup->mobile_width = Tools::getValue('mobile_width');

				$ppopup->mobile_height = Tools::getValue('mobile_height');

				$ppopup->tablet_width = Tools::getValue('tablet_width');

				$ppopup->tablet_height = Tools::getValue('tablet_height');

				$ppopup->redisplay = '30';

				$ppopup->body = Tools::getValue('ppbody');

				$ppopup->tablet = Tools::getValue('pptablet');

				$ppopup->mobile = Tools::getValue('ppmobile');



				$ppopup->name = Tools::getValue('title');

				$ppopup->unlogged = (Tools::getValue('unlogged', 'false') != 'false' ? Tools::getValue('unlogged') : 0);

				$ppopup->redisplay = Tools::getValue('redisplay');

				$ppopup->testmode = (Tools::getValue('testmode', 'false') != 'false' ? Tools::getValue('testmode') : 0);

				$ppopup->add();

			}

		}



		if (Tools::getValue('action', 'false') != 'false')

		{

			if (Tools::getValue('action') == 'updatepopup')

			{

				$ppopup = new ppopup(Tools::getValue('id_ppopup'));

				$ppopup->bgcolor = Tools::getValue('popup_overlay_bg');

				$ppopup->opacity = Tools::getValue('popup_overlay_opacity');

				$ppopup->border = Tools::getValue('popup_border_width');

				$ppopup->border_bg = Tools::getValue('popup_border_color');

				$ppopup->popup_bg = Tools::getValue('ppopup_bg');

				$ppopup->width = Tools::getValue('popup_width');

				$ppopup->height = Tools::getValue('popup_height');

				$ppopup->redisplay = '30';

				$ppopup->body = Tools::getValue('ppbody');

				$ppopup->name = Tools::getValue('title');

				$ppopup->unlogged = (Tools::getValue('unlogged', 'false') != 'false' ? Tools::getValue('unlogged') : 0);

				$ppopup->redisplay = Tools::getValue('redisplay');

				$ppopup->testmode = (Tools::getValue('testmode', 'false') != 'false' ? Tools::getValue('testmode') : 0);

				$ppopup->mobile_width = Tools::getValue('mobile_width');

				$ppopup->mobile_height = Tools::getValue('mobile_height');

				$ppopup->tablet_width = Tools::getValue('tablet_width');

				$ppopup->tablet_height = Tools::getValue('tablet_height');

				$ppopup->redisplay = '30';

				$ppopup->tablet = Tools::getValue('pptablet');

				$ppopup->mobile = Tools::getValue('ppmobile');



				$ppopup->update();

			}

		}



		if (Tools::getValue('editpopup', 'false') != 'false')

		{

			$this->context->smarty->assign(array(

				'productpopup' => new ppopup((int)Tools::getValue('editpopup')),

				'employee_idlang' => $this->context->cookie->id_lang,

				'thismodule' => $this));

		}

		$id_product = Tools::getValue('id_product');

		$ppopups = new ppopup();

		$product_popups = $ppopups->loadByIdProduct($id_product);

		$this->context->smarty->assign(array(

			'product_popups' => $product_popups,

			'employee_idlang' => $this->context->cookie->id_lang,

			'thismodule' => $this,

			'psversion' => $this->psversion()));

		return $this->display(__file__, 'views/templates/admin/tabs.tpl');

	}

}

