

/**

 * Multi accessories for Pretashop

 *

 * @author    PrestaMonster.com

 * @copyright PrestaMonster.com

 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 */



/**

 * handle envent

 * @param {json} options

 * @returns {PriceTable}

 */

var PriceTable = function (options)

{

	/**

	 * contain all products accessories

	 */

	this.products = typeof options.products !== 'undefined' ? options.products : null;



	/**

	 * contain current id product

	 */

	this.randomMainProductId = typeof options.randomMainProductId !== 'undefined' ? options.randomMainProductId : null;



	/**

	 * contain text translate "sub total"

	 */

	this.subTotal = typeof options.subTotal !== 'undefined' ? options.subTotal : null;



	/**

	 * Change the main price when adding or removing accessories

	 */

	this.changeMainPrice = typeof options.changeMainPrice !== 'undefined' ? options.changeMainPrice : 0;



	/**

	 * Show table price

	 * 1 => show

	 * 0 => hide

	 */

	this.showTablePrice = typeof options.showTablePrice !== 'undefined' ? options.showTablePrice : 0;



	/**

	 * Define warning accessory is out of stock

	 */

	this.warningOutOfStock = options.warningOutOfStock;

	

	/**

	 * Define warning accessory is out of stock

	 */

	this.warningNotEnoughProduct = options.warningNotEnoughProduct;



	/**

	 * contain all selected products

	 */

	this.accessories = {};



	PriceTable.instance = this;



	/**

	 * Define array selectors

	 */

	this._selectors = {

		idCombination : '#idCombination', // define id combination

		mainProductPrice : '#our_price_display', // the box which contains official price of the main item

		accessoryItem: '.accessory_item', // Class of input which select accessory if you want add this accessory to cart.

		classNameAccessoryItem: 'accessory_item', // Class name of input which select accessory if you want add this accessory to cart.

		accessoriesGroup : '.accessories_group', // define class selecte box accessories

		groupAccessories : '#group_accessories', // define id group accessories

		classNameAccessoriesGroup : 'accessories_group', // define class name accessories group

		accessoriesTablePriceContent : '.accessories_table_price_content', // define class table contain price table

		accessoriesCustomQuantity : '.custom_quantity', // define class name of custom quantity of each accessory

		classAttributeList : '#attributes .attribute_list', // define class name of list attribute

		quantityWanted : '#quantity_wanted', // defined class input product quantity

		classChangeQuantity : '#product .product_quantity_down, #product .product_quantity_up', // defined class input change quantity

		productCombination : '#group_accessories .product-combination', // defined class select option change combination

		classProductCombination: '.product-combination', // defined class select option change combination

		classError : 'error-number', // define class name error,

		accessoriesGroupCombination : '#group_accessories .accessories_group_combination', // define class div combination

		classProductImgLink : '.product_img_link', // define class product image link

	};



	/**

	 * Check a value is interger number or not

	 * @param {string} value

	 * @returns {@exp;reg@call;test}

	 */

	this.isIntegerNumber = function (value) {

		var reg = /^\d+$/;

		return reg.test(value);

	};



	/**

	 * Event load default

	 */

	this.onLoad = function ()

	{

		if ($.isEmptyObject(this.products))

			return;



		this._updateMainProductPrice();

		this._initProductAccessories();

		this._renderTablePrice();

		this._renderCombinations();



		// update table price

		$(document).on('change', this._selectors.idCombination, function () {

			PriceTable.instance._updateMainProductPrice();

			PriceTable.instance._renderTablePrice();



		});



		// change combination

		$(document).on('focus', this._selectors.productCombination, function () {

			previousValueOfCombination = $(this).val();

		});

		$(document).on('change', this._selectors.productCombination, function () {

			var randomId = $(this).data('randomid');

			var idProductAttribute = parseInt($(this).val());

			customQuantity = $(this).parent().parent().find(PriceTable.instance._selectors.accessoriesCustomQuantity).val();

			customQuantity = typeof customQuantity !== 'undefined' ? customQuantity : PriceTable.instance.products[randomId]['qty'];

			var parentsElement = $(this).parents('tr');

			if (!PriceTable.instance.products[randomId]['combinations'][idProductAttribute]['out_of_stock'] && PriceTable.instance.products[randomId]['combinations'][idProductAttribute]['avaiable_quantity'] < customQuantity)

			{

				$(this).val(previousValueOfCombination);

				alert(PriceTable.instance.warningOutOfStock);

			}

			else

			{

				previousValueOfCombination = $(this).val();

				PriceTable.instance.products[randomId].default_id_product_attribute = idProductAttribute;

				PriceTable.instance._updateMainProductPrice();

				PriceTable.instance._renderTablePrice();

				PriceTable.instance._updateAccessoryPrice(PriceTable.instance.products[randomId]);

				PriceTable.instance._updateProductCombinationImage(parentsElement, PriceTable.instance.products[randomId]);

			}

			



		});



		// Event click on an accessor item

		$(document).on('click', this._selectors.accessoryItem, function() {

			if (parseInt(window.buyTogetherOption) === parseInt(adminProductSetting.BUY_TOGETHER_YES))

			{

				if ($(this).parents('table').find(PriceTable.instance._selectors.accessoryItem + ':checked').length === 0)

				{

					alert(alertMessage);

					$(this).parent().addClass('checked');

					$(this).attr("checked", "checked");

				}

			}

			else if (parseInt(window.buyTogetherOption) === parseInt(adminProductSetting.BUY_TOGETHER_REQUIRED) && $(this).attr('type') === 'checkbox')

			{

				if (parseInt($(this).data('required-buy-together')) === 1)

				{

					alert(alertMessage);

					$(this).parent().addClass('checked');

					$(this).attr("checked", "checked");

				}

			}

			PriceTable.instance._initProductAccessories();

			PriceTable.instance._renderTablePrice();

		});



		// Event click and change combination

		$(document).on('click', this._selectors.classAttributeList, function (e) {

			PriceTable.instance._renderTablePrice();

		});



		//$(this._selectors.accessoriesGroup).data('pre', $(this).val());

		$(this._selectors.accessoriesGroup).on('focus', function() {

			// Store the current value on focus and on change

			previousAccessory = this.value;

		}).change(function() {

			var randomId = $(this).find(':selected').data('randomid');

			

			if (typeof randomId !== 'undefined')

			{

				var customQuantity = PriceTable.instance.products[randomId].custom_quantity ? PriceTable.instance.products[randomId].custom_quantity : PriceTable.instance.products[randomId].default_quantity;

				var idProductAttribute = this.options[this.selectedIndex].getAttribute('data-idproductattribute');

				var isOutOfStock = false;

				if (!PriceTable.instance.products[randomId]['out_of_stock'] && PriceTable.instance.products[randomId]['avaiable_quantity'] < customQuantity)

					isOutOfStock = true;

				

				if (typeof idProductAttribute !== 'undefined' &&

					typeof PriceTable.instance.products[randomId]['combinations'][idProductAttribute] !== 'undefined' &&

					!PriceTable.instance.products[randomId]['combinations'][idProductAttribute]['out_of_stock'] &&

					PriceTable.instance.products[randomId]['combinations'][idProductAttribute]['avaiable_quantity'] < customQuantity

					)

					isOutOfStock = true;



				if (isOutOfStock)

				{

					$(this).val(previousAccessory);

					alert(PriceTable.instance.warningOutOfStock);

				}

				else

				{

					if (typeof PriceTable.instance.products[randomId] !== 'undefined' && PriceTable.instance.products[randomId]['combinations'].length > 1)

						PriceTable.instance._renderCombination(randomId, false);

					else

						$(this).next().html('');

					previousAccessory = this.value;

				}

			}

			else

			{

				$(this).next().html('');

				previousAccessory = this.value;

			}

			PriceTable.instance._initProductAccessories();

			PriceTable.instance._renderTablePrice();

		});



		// Event change the quantity of main product

		$(document).on('keyup', this._selectors.quantityWanted, function () {

			var qty = $(this).val();

			isIntegerNumber = PriceTable.instance.isIntegerNumber(qty);

			if (!isIntegerNumber)

			{

				$(this).addClass(PriceTable.instance._selectors.classError);

				$(this).select();

			}

			else

				$(this).removeClass(PriceTable.instance._selectors.classError);



			PriceTable.instance._updateMainProductPrice();

			PriceTable.instance._initProductAccessories();

			PriceTable.instance._renderTablePrice();

		});



		// up & down qty button on PS 1.6

		$(document).on('click', this._selectors.classChangeQuantity, function () {

			PriceTable.instance._updateMainProductPrice();

			PriceTable.instance._initProductAccessories();

			PriceTable.instance._renderTablePrice();

		});



		if ($('#product' + ' ' + this._selectors.groupAccessories + ' ' + this._selectors.accessoriesCustomQuantity).length > 0)

		{

			// Event change the custom quantity value

			$(this._selectors.accessoriesCustomQuantity).on('focus', function() {

				// Store the current value on focus and on change

				previousAccessoryQuantity = this.value;

			}).keyup(function() {

				var newQuantity = parseInt($(this).val());

				var randomId = 0;

				var idCombination = 0;

				randomId = typeof $(this).next().find(':selected').data('randomid') !== 'undefined' ? $(this).next().find(':selected').data('randomid') : $(this).parent().parent().find(PriceTable.instance._selectors.accessoryItem).data('randomid');

				idCombination = typeof $(this).next().find(':selected').data('idproductattribute') !== 'undefined' ? $(this).next().find(':selected').data('idproductattribute') : $(this).parent().parent().find(PriceTable.instance._selectors.accessoryItem).data('idproductattribute');

				var isStockAvailable = PriceTable.instance.isStockAvailable(randomId, newQuantity, idCombination);

				if(isStockAvailable)

				{

					isIntegerNumber = PriceTable.instance.isIntegerNumber(newQuantity);

					if (!isIntegerNumber)

					{

						$(this).addClass(PriceTable.instance._selectors.classError);

						$(this).select();

					}

					else

					{

						$(this).removeClass(PriceTable.instance._selectors.classError);

						PriceTable.instance.products[randomId]['custom_quantity'] = newQuantity;

					}

				}

				else

				{

					$(this).val(previousAccessoryQuantity);

					alert(PriceTable.instance.warningNotEnoughProduct);

				}

				PriceTable.instance._initProductAccessories();

				PriceTable.instance._renderTablePrice();

				

			});

		}



		// Event show fancybox when customer click product image

		$(document).on('click', this._selectors.classProductImgLink, function(e) {

			$(PriceTable.instance._selectors.classProductImgLink).fancybox({

				'hideOnContentClick': false

			});

		});

		

	};



	/**

	 * Get all selected products if block accessories

	 */

	this._initProductAccessories = function ()

	{

		this.accessories = {};

		var selector = this._selectors;

		if ($(selector.groupAccessories).find('select').hasClass(this._selectors.classNameAccessoriesGroup))

		{

			$(PriceTable.instance._selectors.accessoriesGroup).each(function ()

			{

				var randomId = $(this).find(':selected').data('randomid');

				if (typeof PriceTable.instance.products[randomId] !== 'undefined')

				{

					var quantity = PriceTable.instance.products[randomId].custom_quantity ? PriceTable.instance.products[randomId].custom_quantity : PriceTable.instance.products[randomId].default_quantity;

					$($(this).prev()).val(quantity);

					PriceTable.instance.accessories[randomId] = PriceTable.instance.products[randomId];

					var qty = parseInt($('#product #quantity_wanted').val());



					if ($('#product' + ' ' + selector.groupAccessories + ' ' + selector.accessoriesCustomQuantity).length > 0)

						qty = $('#quantity_' + $(this).attr('name').replace('accessory_', '')).val();



					if (qty >= 1)

						PriceTable.instance.products[randomId]['qty'] = qty;

					if (PriceTable.instance.products[randomId]['combinations'].length > 1)

						PriceTable.instance._renderCombination(randomId, false);

				}

				

			});

		}

		if ($(selector.groupAccessories).find('input').hasClass(this._selectors.classNameAccessoryItem))

		{

			$(PriceTable.instance._selectors.accessoryItem + ':checked').each(function(i)

			{

				var randomId = $(this).data('randomid');

				var qty = parseInt($('#product #quantity_wanted').val());

				if (typeof PriceTable.instance.products[randomId] !== 'undefined')

				{

					PriceTable.instance.accessories[randomId] = PriceTable.instance.products[randomId];

					if ($('#product' + ' ' + selector.groupAccessories + ' ' + selector.accessoriesCustomQuantity).length > 0)

						qty = parseInt($('#quantity_' + $(this).attr('id').replace('accessories_proudct_', '')).val());



					if (qty >= 1)

						PriceTable.instance.products[randomId]['qty'] = qty;

				}

			});

		}

		

		this.accessories[PriceTable.instance.randomMainProductId] = PriceTable.instance.products[PriceTable.instance.randomMainProductId];



	};



	/**

	 * update main product price when change combination

	 */

	this._updateMainProductPrice = function ()

	{

            if (typeof productPrice === 'undefined')

                return;

		// in this case, the current product does not have any combination, so no need to update price of the main item

		// refer to product.js::updatePrice()

		

		if (typeof priceWithDiscountsDisplay === 'undefined')

			priceWithDiscountsDisplay = productPrice;

		PriceTable.instance.products[PriceTable.instance.randomMainProductId]['combinations'][PriceTable.instance.products[PriceTable.instance.randomMainProductId]['default_id_product_attribute']]['price'] = priceWithDiscountsDisplay;

		var qty = $('#product #quantity_wanted').val();

		if (typeof qty !== 'undefined')

		{

			if (PriceTable.instance.isIntegerNumber(qty) && parseInt(qty) >= 1)

				PriceTable.instance.products[PriceTable.instance.randomMainProductId]['qty'] = parseInt(qty);

		}

	};



	/**

	 * render price table

	 */

	this._renderTablePrice = function ()

	{

		if ($.isEmptyObject(this.accessories))

			return;



		var priceTable = '';

		var underline = '';

		var totalPrice = 0;

		$.each(this.accessories, function (randomid, product)

		{

			var productPrice = 0;

			$.each(product.combinations, function (idProductAttribute, combination) {

				if (typeof combination !== 'undefined' && parseInt(product.default_id_product_attribute) === parseInt(idProductAttribute))

					productPrice = product.qty * combination.price;

				if (!$.isEmptyObject(combination.specific_prices))

				{

					$.each(combination.specific_prices, function (fromQty, specificPrice) {

						if (product.qty >= fromQty)

							productPrice = product.qty * specificPrice;

					});

				}

			});

			var outOfStockWarningIcon = PriceTable.instance._renderOutOfStockWarningIcon(product);

			underline = randomid === PriceTable.instance.randomMainProductId ? 'style="text-decoration: underline;"' : '';

			totalPrice += productPrice;

			priceTable = priceTable + '<tr>' +

					'<td class="left-column" ' + underline + '><span class="ma_accessory_name" title="' + product.name + '">' + product.qty + ' x ' + product.name + ':</span></td>' +

				'<td class="right-column">' + formatCurrency(productPrice, currencyFormat, currencySign, currencyBlank) + outOfStockWarningIcon + '</td>' +

					'</tr>';

		});



		var totals = formatCurrency(totalPrice, currencyFormat, currencySign, currencyBlank);

		priceTable = priceTable + '<tr>' +

				'<td class="left-column-total">' + this.subTotal + ':</td>' +

				'<td class="right-column-total">' + totals + '</td>' +

				'</tr>';



		if (parseInt(this.showTablePrice) === 1)

			$(this._selectors.accessoriesTablePriceContent).html(priceTable);



		if (this.changeMainPrice)

			$(this._selectors.mainProductPrice).html(totals);

	};



	/**

	 * Render out of stock warning icon

	 * @param {object} product

	 * @returns {string}

	 */

	this._renderOutOfStockWarningIcon = function(product)

	{

		var outOfStockWarningIcon = '<span title="'+ product.available_later +'" class="warning_out_of_stock"></span>';

		return product.is_available_when_out_of_stock ? outOfStockWarningIcon : '';

	};



	/**

	 * Render list combinations of products

	 */

	this._renderCombinations = function ()

	{

		if ($(this._selectors.groupAccessories).find('select').hasClass(this._selectors.classNameAccessoriesGroup))

		{

			$(PriceTable.instance._selectors.accessoriesGroup).each(function ()

			{

				var randomId = $(this).val();

				if (typeof PriceTable.instance.products[randomId] !== 'undefined' && PriceTable.instance.products[randomId]['combinations'].length > 1)

					PriceTable.instance._renderCombination(randomId, false);

			});



		}

		if ($(this._selectors.groupAccessories).find('input').hasClass(this._selectors.classNameAccessoryItem))

		{   

			$.each(this.products, function (randomId, product) {

                            if (Object.keys(product.combinations).length > 1)

                                PriceTable.instance._renderCombination(randomId, true);

			});

		}

		

	};



	/**

	 * Render combination of one product

	 * @param {string} randomId

	 * @param {boolean} checkbox

	 */

	this._renderCombination = function (randomId, checkbox)

	{       

		var product = this.products[randomId];

		var html = '<select data-randomid="' + randomId + '" name="product-combination" class="product-combination">';

		$.each(product.combinations, function (idProductAttribute, combination) {

			var selected = '';

			if (parseInt(idProductAttribute) === parseInt(product.default_id_product_attribute))

				selected = 'selected="selected"';

			html += '<option value="' + idProductAttribute + '"' + selected + '>' + combination.name + '</option>';

		});



		html += '</select>';

                var classContainCombination = 'combination_'+product.id_accessory_group+'_'+product.id_accessory;

		if (checkbox)

			$('.' + classContainCombination).html(html);

		else

		{

			var selector = product.class_contain_combination.slice(0, -2);

			html = '<label class="group_name">&nbsp;</label>' + html;

			$('.' + selector).html(html);

		}



	};



	/**

	 * Update price of product accessory

	 * @param {object} product

	 */

	this._updateAccessoryPrice = function (product)

	{

		var price = product.combinations[product.default_id_product_attribute].price;

		if (price > 0)

		{

                    var classContainPrice = 'price_'+product.id_accessory_group+'_'+product.id_accessory;;

                    $('.' + classContainPrice).html(formatCurrency(price, currencyFormat, currencySign, currencyBlank));

                }

	};



	/**

	 * Update image of product when change combination

	 * @param {Jquery} element

	 * @param {Object} product

	 */

	this._updateProductCombinationImage = function (element, product)

	{

		var selectedCombination = product.combinations[product.default_id_product_attribute];

		$(element).find('.accessory_img_link').attr('href', selectedCombination.image_fancybox);

		$(element).find('.accessory_image').attr('src', selectedCombination.image_default);



	};

	

	/**

	 * Check stock available of accessory when customer change quantity at front end

	 * @param {string} randomId

	 * @param {int} newQuantity

	 * @param {int} idCombination

	 * @returns {Boolean}

	 */

	this.isStockAvailable = function (randomId, newQuantity, idCombination)

	{

		var flag = true;

		idCombination = typeof idCombination !== 'undefined' ? idCombination : 0;

		var product = this.products[randomId].combinations[idCombination];

		var availableQuantity = product.avaiable_quantity;

		var outOfStock = product.out_of_stock;

		if (!outOfStock && availableQuantity < newQuantity)

			flag = false;

		return flag;

	};

};

