

/**

 * Override function add of cart object to add accessory to cart with ogrinal product

 * Copyright (c) 2014 PrestaMonster.com

 * @param {int} idProduct

 * @param {int} idCombination

 * @param {string} addedFromProductPage

 * @param {string} callerElement

 * @param {float} quantity

 * @param {array} wishlist

 */

if(typeof ajaxCart === 'undefined')

    ajaxCart = {};

ajaxCart.add = function(idProduct, idCombination, addedFromProductPage, callerElement, quantity, wishlist)

{

	var isEnoughtAccessory = true;

	var groupAccessories = $('#group_accessories').find('select');

	var idAccesories = [];

	var idAccesoriesAttributes = [];

	var customQty = [];

	if (groupAccessories.hasClass('accessories_group'))

	{

		$('.accessories_group option:selected').each(function (i) {



			if (parseInt($(this).val()) > 0)

			{

				var parentElement = $(this).parents('.option-row');

				idAccesories.push(parseInt($(this).val()));

				if ($(parentElement).find('select').hasClass('product-combination'))

					idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));

				else

					idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));



				if ($(parentElement).find('input').hasClass('custom_quantity'))

					customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));

			}

		});

	}

	if ($('#group_accessories').find('input').hasClass('accessory_item'))

	{

		if (addedFromProductPage)

		{

			$('#group_accessories .accessory_item' + ':checked').each(function(i)

			{

				idAccesories.push(parseInt($(this).val()));

				var parentElement = $(this).parents('tr');



				if ($(parentElement).find('select').hasClass('product-combination'))

					idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));

				else

					idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));



				if ($(parentElement).find('input').hasClass('custom_quantity'))

					customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));

			});



			if (parseInt(window.buyTogetherOption) === parseInt(adminProductSetting.BUY_TOGETHER_YES))

			{

				$('#group_accessories .accessorygroup').each(function() {

					var numberCheckedAccessory = $(this).find('.accessory_item' + ':checked').length;

					if (!numberCheckedAccessory)

						isEnoughtAccessory = false;

				});

			}

		}

	}



	if (idAccesories.length > 0)

		idAccesories = idAccesories.join(",");

	if (idAccesoriesAttributes.length > 0)

		idAccesoriesAttributes = idAccesoriesAttributes.join(",");

	if (customQty.length > 0)

		customQty = customQty.join(",");



	if (!isEnoughtAccessory)

	{

		alert(alertMessage);

		return false;

	}



    if (addedFromProductPage && !checkCustomizations())

    {

	    alert(fieldRequired);

	    return ;

    }

    emptyCustomizations();

    //disabled the button when adding to not double add if user double click

    if (addedFromProductPage)

    {

	    $('#add_to_cart input').attr('disabled', true).removeClass('exclusive').addClass('exclusive_disabled');

	    $('.filled').removeClass('filled');

    }

    else

	    $(callerElement).attr('disabled', true);



    if ($('#cart_block_list').hasClass('collapsed'))

	    this.expand();



	if (typeof idProduct === 'undefined')

		return;



    //send the ajax request to the server

    $.ajax({

	    type: 'POST',

	    headers: { "cache-control": "no-cache" },

	    url: baseUri + '?rand=' + new Date().getTime(),

	    async: true,

	    cache: false,

	    dataType : "json",

	    data : 'controller=cart&add=1&ajax=true&qty=' + ((quantity && quantity !== null) ? quantity : '1') + '&id_product=' + idProduct + '&token=' + static_token + ((parseInt(idCombination) && idCombination !== null) ? '&ipa=' + parseInt(idCombination) : '') + (idAccesories !== '' ? '&id_accessories=' + idAccesories : '') + (customQty !== '' ? '&custom_qty=' + customQty : '') + (idAccesoriesAttributes !== '' ? '&id_accesories_attributes=' + idAccesoriesAttributes : ''),

	    success: function(jsonData,textStatus,jqXHR)

	    {

		    // add appliance to wishlist module

		    if (wishlist && !jsonData.errors)

			    WishlistAddProductCart(wishlist[0], idProduct, idCombination, wishlist[1]);



		    // add the picture to the cart

		    //var $element = $(callerElement).parent().parent().find('a.product_image img,a.product_img_link img');

		    var $element = $(callerElement).parents('.accessorygroup').find('.accessory_image');

                    if (!$element.length)

			    $element = $('#bigpic');

		    var $picture = $element.clone();

		    var pictureOffsetOriginal = $element.offset();

		    pictureOffsetOriginal.right = $(window).innerWidth() - pictureOffsetOriginal.left - $element.width();



		    if ($picture.length)

		    {

			    $picture.css({

				    position: 'absolute',

				    top: pictureOffsetOriginal.top,

				    right: pictureOffsetOriginal.right

			    });

		    }



		    var pictureOffset = $picture.offset();

		    var cartBlock = $('#cart_block');

		    if (!$('#cart_block')[0] || !$('#cart_block').offset().top || !$('#cart_block').offset().left)

			    cartBlock = $('#shopping_cart');

		    var cartBlockOffset = cartBlock.offset();

		    cartBlockOffset.right = $(window).innerWidth() - cartBlockOffset.left - cartBlock.width();



		    // Check if the block cart is activated for the animation

		    if (cartBlockOffset !== undefined && $picture.length)

		    {

			    $picture.appendTo('body');

			    $picture

				    .css({

					    position: 'absolute',

					    top: pictureOffsetOriginal.top,

					    right: pictureOffsetOriginal.right,

					    zIndex: 4242

				    })

				    .animate({

					    width: $element.attr('width')*0.66,

					    height: $element.attr('height')*0.66,

					    opacity: 0.2,

					    top: cartBlockOffset.top + 30,

					    right: cartBlockOffset.right + 15

				    }, 1000)

				    .fadeOut(100, function() {

					    ajaxCart.updateCartInformation(jsonData, addedFromProductPage);

					    $(this).remove();

				    });

		    }

		    else

			    ajaxCart.updateCartInformation(jsonData, addedFromProductPage);

	    },

	    error: function(XMLHttpRequest, textStatus, errorThrown)

	    {

		    alert("Impossible to add the product to the cart.\n\ntextStatus: '" + textStatus + "'\nerrorThrown: '" + errorThrown + "'\nresponseText:\n" + XMLHttpRequest.responseText);

		    //reactive the button when adding has finished

		    if (addedFromProductPage)

			    $('#add_to_cart input').removeAttr('disabled').addClass('exclusive').removeClass('exclusive_disabled');

		    else

			    $(callerElement).removeAttr('disabled');

	    }

    });

};



