/**
 * Multi accessories for Pretashop
 *
 * @author    PrestaMonster.com
 * @copyright PrestaMonster.com
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

/**
 * Override function add of cart object to add accessory to cart with ogrinal product
 * Copyright (c) 2014 PrestaMonster.com
 * @param {int} idProduct
 * @param {int} idCombination
 * @param {string} addedFromProductPage
 * @param {string} callerElement
 * @param {float} quantity
 * @param {array} wishlist
 */
ajaxCart.add = function (idProduct, idCombination, addedFromProductPage, callerElement, quantity, wishlist)
{
    var isEnoughtAccessory = true;
    var groupAccessories = $('#group_accessories').find('select');
    var idAccesories = [];
    var idAccesoriesAttributes = [];
    var customQty = [];
    if (groupAccessories.hasClass('accessories_group'))
    {
        $('.accessories_group option:selected').each(function (i) {

            if (parseInt($(this).val()) > 0)
            {
                var parentElement = $(this).parents('.option-row');
                idAccesories.push(parseInt($(this).val()));
                if ($(parentElement).find('select').hasClass('product-combination'))
                    idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));
                else
                    idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));

                if ($(parentElement).find('input').hasClass('custom_quantity'))
                    customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));
            }
        });
    }
    if ($('#group_accessories').find('input').hasClass('accessory_item'))
    {
        if (addedFromProductPage)
        {
            $('#group_accessories .accessory_item' + ':checked').each(function (i)
            {
                idAccesories.push(parseInt($(this).val()));
                var parentElement = $(this).parents('tr');

                if ($(parentElement).find('select').hasClass('product-combination'))
                    idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));
                else
                    idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));

                if ($(parentElement).find('input').hasClass('custom_quantity'))
                    customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));
            });

            if (parseInt(window.buyTogetherOption) === parseInt(adminProductSetting.BUY_TOGETHER_YES))
            {
                $('#group_accessories .accessorygroup').each(function () {
                    var numberCheckedAccessory = $(this).find('.accessory_item' + ':checked').length;
                    if (!numberCheckedAccessory)
                        isEnoughtAccessory = false;
                });
            }
        }
    }

    if (idAccesories.length > 0)
        idAccesories = idAccesories.join(",");
    if (idAccesoriesAttributes.length > 0)
        idAccesoriesAttributes = idAccesoriesAttributes.join(",");
    if (customQty.length > 0)
        customQty = customQty.join(",");

    if (!isEnoughtAccessory)
    {
        alert(alertMessage);
        return false;
    }

    if (addedFromProductPage && !checkCustomizations())
    {
        if (!!$.prototype.fancybox)
            $.fancybox.open([
                {
                    type: 'inline',
                    autoScale: true,
                    minHeight: 30,
                    content: '<p class="fancybox-error">' + fieldRequired + '</p>'
                }
            ], {
                padding: 0
            });
        else
            alert(fieldRequired);
        return;
    }
    emptyCustomizations();
    //disabled the button when adding to not double add if user double click
    if (addedFromProductPage)
    {
        $('#add_to_cart button').prop('disabled', 'disabled').addClass('disabled');
        $('.filled').removeClass('filled');

    }
    else
        $(callerElement).prop('disabled', 'disabled');

    if ($('.cart_block_list').hasClass('collapsed'))
        this.expand();

    if (typeof idProduct === 'undefined')
        return;

    //send the ajax request to the server
    $.ajax({
        type: 'POST',
        headers: {"cache-control": "no-cache"},
        url: baseUri + '?rand=' + new Date().getTime(),
        async: true,
        cache: false,
        dataType: "json",
        data: 'controller=cart&add=1&ajax=true&qty=' + ((quantity && quantity !== null) ? quantity : '1') + '&id_product=' + idProduct + '&token=' + static_token + ((parseInt(idCombination) && idCombination !== null) ? '&ipa=' + parseInt(idCombination) : '') + (idAccesories !== '' ? '&id_accessories=' + idAccesories : '') + (customQty !== '' ? '&custom_qty=' + customQty : '') + (idAccesoriesAttributes !== '' ? '&id_accesories_attributes=' + idAccesoriesAttributes : ''),
        success: function (jsonData)
        {
            // add appliance to whishlist module
            if (wishlist && !jsonData.errors)
                WishlistAddProductCart(wishlist[0], idProduct, idCombination, wishlist[1]);

            if (!jsonData.hasError)
            {
                window.parent.ajaxCart.updateCartInformation(jsonData, addedFromProductPage);

                if (jsonData.crossSelling)
                    $('.crossseling').html(jsonData.crossSelling);

                if (idCombination)
                    $(jsonData.products).each(function () {
                        if (this.id !== undefined && parseInt(this.id) === parseInt(idProduct) && parseInt(this.idCombination) === parseInt(idCombination))
                            window.parent.ajaxCart.updateLayer(this);
                    });
                else
                    $(jsonData.products).each(function () {
                        if (this.id !== undefined && parseInt(this.id) === parseInt(idProduct))
                            window.parent.ajaxCart.updateLayer(this);
                    });
                if (contentOnly)
                    parent.$.fancybox.close();
            }
            else
            {
                if (addedFromProductPage)
                    $('#add_to_cart button').removeProp('disabled').removeClass('disabled');
                else
                    $(callerElement).removeProp('disabled');

                alert(jsonData.errors);
            }

        },
        error: function (XMLHttpRequest, textStatus, errorThrown)
        {
            var error = "Impossible to add the product to the cart.<br/>textStatus: '" + textStatus + "'<br/>errorThrown: '" + errorThrown + "'<br/>responseText:<br/>" + XMLHttpRequest.responseText;
            if (!!$.prototype.fancybox)
                $.fancybox.open([
                    {
                        type: 'inline',
                        autoScale: true,
                        minHeight: 30,
                        content: '<p class="fancybox-error">' + error + '</p>'
                    }],
                        {
                            padding: 0
                        });
            else
                alert(error);
            //reactive the button when adding has finished
            if (addedFromProductPage)
                $('#add_to_cart button').removeProp('disabled').removeClass('disabled');
            else
                $(callerElement).removeProp('disabled');
        }
    });


};
