/**

 * Multi accessories for Pretashop

 *

 * @author    PrestaMonster.com

 * @copyright PrestaMonster.com

 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 */



/**

 * Override function add of cart object to add accessory to cart with ogrinal product

 * After adding product and accessories to cart => redirect to order page

 * @param {int} idProduct

 * @param {int} idCombination

 * @param {int} quantity

 */

function addToCart(idProduct, idCombination, quantity, mainPorduct)

{

    var isEnoughtAccessory = true;

    var groupAccessories = $('#group_accessories').find('select');

    var idAccesories = [];

    var idAccesoriesAttributes = [];

    var customQty = [];

    if (groupAccessories.hasClass('accessories_group'))

    {

        $('.accessories_group option:selected').each(function (i) {



            if (parseInt($(this).val()) > 0)

            {

                var parentElement = $(this).parents('.option-row');

                idAccesories.push(parseInt($(this).val()));

                if ($(parentElement).find('select').hasClass('product-combination'))

                    idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));

                else

                    idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));



                if ($(parentElement).find('input').hasClass('custom_quantity'))

                    customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));

            }

        });

    }

    if ($('#group_accessories').find('input').hasClass('accessory_item'))

    {

        if (mainPorduct)

        {

            $('#group_accessories .accessory_item' + ':checked').each(function (i)

            {

                idAccesories.push(parseInt($(this).val()));

                var parentElement = $(this).parents('tr');



                if ($(parentElement).find('select').hasClass('product-combination'))

                    idAccesoriesAttributes.push(parseInt($(parentElement).find('.product-combination').val()));

                else

                    idAccesoriesAttributes.push(parseInt($(this).data('idproductattribute')));



                if ($(parentElement).find('input').hasClass('custom_quantity'))

                    customQty.push(parseInt($(parentElement).find('.custom_quantity').val()));

            });



            if (parseInt(window.buyTogetherOption) === parseInt(adminProductSetting.BUY_TOGETHER_YES))

            {

                $('#group_accessories .accessorygroup').each(function () {

                    var numberCheckedAccessory = $(this).find('.accessory_item' + ':checked').length;

                    if (!numberCheckedAccessory)

                        isEnoughtAccessory = false;

                });

            }

        }

    }



    if (idAccesories.length > 0)

        idAccesories = idAccesories.join(",");

    if (idAccesoriesAttributes.length > 0)

        idAccesoriesAttributes = idAccesoriesAttributes.join(",");

    if (customQty.length > 0)

        customQty = customQty.join(",");

    if (!isEnoughtAccessory)

    {

        alert(alertMessage);

        return false;

    }



    //send the ajax request to the server

    $.ajax({

        type: 'POST',

        headers: {"cache-control": "no-cache"},

        url: baseUri + '?rand=' + new Date().getTime(),

        async: true,

        cache: false,

        dataType: "json",

        data: 'controller=cart&add=1&ajax=true&qty=' + ((quantity && quantity !== null) ? quantity : '1') + '&id_product=' + idProduct + '&token=' + static_token + ((parseInt(idCombination) && idCombination !== null) ? '&ipa=' + parseInt(idCombination) : '') + (idAccesories !== '' ? '&id_accessories=' + idAccesories : '') + (customQty !== '' ? '&custom_qty=' + customQty : '') + (idAccesoriesAttributes !== '' ? '&id_accesories_attributes=' + idAccesoriesAttributes : ''),

        success: function ()

        {

            window.location.href = orderUrl;

        },

        error: function (XMLHttpRequest, textStatus, errorThrown)

        {

            var error = "Impossible to add the product to the cart.<br/>textStatus: '" + textStatus + "'<br/>errorThrown: '" + errorThrown + "'<br/>responseText:<br/>" + XMLHttpRequest.responseText;

            if (!!$.prototype.fancybox)

                $.fancybox.open([

                    {

                        type: 'inline',

                        autoScale: true,

                        minHeight: 30,

                        content: '<p class="fancybox-error">' + error + '</p>'

                    }],

                        {

                            padding: 0

                        });

            else

                alert(error);



        }

    });

}