<?php

/**

 * Multi Accessories for Pretashop.

 *

 * @author    PrestaMonster.com

 * @copyright PrestaMonster.com

 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 */



require_once dirname(__FILE__).'/AbstractAdminHsMultiAccessoriesCommon.php';



/**

 * Controller of admin page - Multi Accessories (Abstract).

 */

class AdminHsMultiAccessoriesWelcomePageAbstract extends AbstractAdminHsMultiAccessoriesCommon

{

    protected $change_logs = array(

        'v.2.8.0' => array(

            '[Feature] Make accessory groups sortable',

            '[Feature] Make accessories sortable',

        ),

        'v.2.7.0' => array(

            'Search accessories in multi shop',

            'Redesign layout of Multi Accessories tab in product page',

            'Show icon warning if accessory is out of stock but backordering is allowed',

        ),

        'v.2.6.0' => array(

            '[FEATURE] Introduce new option to show accessories as radios',

            '[FEATURE] Display style is set by accessory group',

            '[FEATURE] An ability to generate accessory images manually',

            '[FEATURE] Duplicate accessories when duplicating a product',

            '[IMPROVEMENT] Out-of-stock accessories are not allowed to check out',

            '[IMPROVEMENT] Show description when hovering on an accessory',

            '[IMPROVEMENT] Update product price on changing combinations even it does not have any accessory',

            '[IMPROVEMENT] Combination name is editable',

        ),

        'v.2.5.0' => array(

            'Generate product images manually',

            'Duplicate accessories when customer duplicate product',

            'Support edit name accessories',

        ),

        'v.2.4.0' => array(

            'FEATURE Work with combinations',

        ),

        'v.2.3.0' => array(

            'FEATURE Work with specific prices',

            'FEATURE Custom quantity for each accessory',

            'IMPROVEMENT Display accessory images in Fancybox',

            'FEATURE Custom quantity for each accessory',

        ),

        'v.2.2.0' => array(

            'FEATURE An ability to add each accessory to shopping cart',

            'IMPROVEMENT Display cost of main item and selected accessories together',

        ),

    );



    /**

     * Show result to view.

     *

     * @var type json

     */

    protected $ajax_json = array(

        'success' => false,

    );



    /**

     * All css files which should be loaded.

     *

     * @var array

     */

    protected $module_media_css = array(

        'welcome_page.css',

        'icon-menu-pos.css',

    );



    /**

     * Define link of addon page.

     *

     * @var string

     */

    protected $link_to_addon_page = 'http://addons.prestashop.com/en/ratings.php';



    /**

     * Define link of orestamonster page.

     *

     * @var string

     */

    protected $link_to_prestamonster = 'http://addons.prestashop.com/en/89_prestamonster';



    /**

     * construct.

     */

    public function __construct()

    {

        $this->bootstrap = true;

        parent::__construct();

    }



    /**

     * @see AdminControllerCore::initContent()

     */

    public function initContent()

    {

        parent::initContent();

        // update status go to page welcome when install or upgrade module

        Configuration::updateValue($this->module->getKeyWelcomePage(), 1);

        $this->context->smarty->assign(array(

            'module_name' => $this->module->name,

            'module_version' => $this->module->version,

            'change_logs' => $this->change_logs,

            'link_to_addon_page' => $this->link_to_addon_page,

            'is_prestashop_16' => $this->module->isPrestashop16(),

            'link_module_homepage' => $this->context->link->getAdminLink($this->module->class_controller_admin_group),

        ));

    }



    /**

     * Set Media file include when controller called.

     */

    public function setMedia()

    {

        parent::setMedia();

        if (!empty($this->module_media_css) && is_array($this->module_media_css)) {

            $css_files = array();

            foreach ($this->module_media_css as $css_file) {

                $css_file = $this->module->getCssPath().$css_file;

                if (version_compare(_PS_VERSION_, '1.6') === -1 || version_compare(_PS_VERSION_, '1.7') === 1) {

                    $css_file = $css_file.'?'.$this->module->name.'='.$this->module->version;

                }

                $css_files[] = $css_file;

            }

            $this->addCSS($css_files);

        }

    }



    /**

     * Initinalize all translations.

     */

    protected function initTranslations()

    {

        parent::initTranslations();

        $source = basename(__FILE__, '.php');

        $this->context->smarty->assign(array(

            'welcome_to' => str_replace(array('[span]', '[/span]'), array('<span class="module_name">', '</span>'), sprintf($this->l('Welcome to [span]%s %s[/span]!', $source), $this->module->displayName, $this->module->version)),

            'an_awesome_PrestaShop_solution_provided_by_prestamonster' => $this->l('An awesome PrestaShop solution provided by PrestaMonster.', $source),

            'change_log' => $this->l('Change log', $source),

            'read_more' => $this->l('Read more...', $source),

            'thank_you_and_take_me_to' => sprintf($this->l('Thank you, and take me to %s', $source), $this->module->displayName),

            'share_your_reviews' => $this->l('Share your reviews', $source),

            'and_as_a_result_you_will_get_more_values_from_us' => $this->l('And as a result, you will get more values from us.', $source),

            'add_your_on_addons_prestashop_com_to_help_us' => str_replace(array('[span]', '[/span]'), array('<span class="vote_star">', '</span>'), sprintf($this->l('Add your [span]%s[/span] on %s to help us improve %s continuously.', $source), '<a href="'.$this->link_to_addon_page.'" target="_blank">'.$this->l('★★★★★', $source).'</a>', '<a href="'.$this->link_to_addon_page.'" target="_blank">'.$this->l('addons.prestashop.com', $source).'</a>', $this->module->displayName)),

            'just_log_into_prestashop_addons_with_your_credentials' => sprintf($this->l('Just log into %s with your credentials, then visit this page and look for the right order number.', $source), '<a href="'.$this->link_to_addon_page.'" target="_blank">'.$this->l('Prestashop Addons', $source).'</a>'),

            'looking_for_even_better_prestashop_modules' => $this->l('Looking for even better PrestaShop modules?', $source),

            'take_a_look_at_all_modules_developed_by_prestamonster' => sprintf($this->l('Take a look at all modules developed by %s.', $source), '<a href="'.$this->link_to_prestamonster.'" target="_blank">'.$this->l('PrestaMonster', $source).'</a>'),

        ));

    }

}

