<?php

/**

 * Multi Accessories for Prestashop.

 *

 * @author    PrestaMonster.com

 * @copyright PrestaMonster.com

 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 */



class HsMaSearch extends Search

{

    /**

     * Search accessories.

     *

     * @param string $exclude_ids

     * @param string $keyword

     * @param string $exclude_virtuals

     * @param string $exclude_packs

     *

     * @return array

     *               array<pre>

     *               (

     *               [0] => array

     *               (

     *               [id_product] => 44

     *               [link_rewrite] => paypal-fee

     *               [reference] =>

     *               [name] => Paypal fee

     *               )

     *               [1] => array

     *               (

     *               [id_product] => 47

     *               [link_rewrite] => faded-short-sleeve-tshirts

     *               [reference] => demo_1

     *               [name] => Faded Short Sleeve T-shirts1

     *               )

     *               ...

     *               )</pre>

     */

    public static function searchAccessories($exclude_ids, $keyword, $exclude_virtuals, $exclude_packs)

    {

        $sql = 'SELECT p.`id_product`, pl.`link_rewrite`, p.`reference`, pl.`name`

		FROM `'._DB_PREFIX_.'product` p

		LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (pl.`id_product` = p.`id_product` AND pl.`id_lang` = '.(int) Context::getContext()->language->id.Shop::addSqlRestrictionOnLang('pl').')

		LEFT JOIN `'._DB_PREFIX_.'product_shop` ps ON (ps.`id_product` = p.`id_product`)

		WHERE (pl.`name` LIKE \'%'.pSQL($keyword).'%\' OR p.`reference` LIKE \'%'.pSQL($keyword).'%\')'.

            (!empty($exclude_ids) ? ' AND p.`id_product` NOT IN ('.$exclude_ids.') ' : ' ').

            ($exclude_virtuals ? 'AND p.`id_product` NOT IN (SELECT pd.`id_product` FROM `'._DB_PREFIX_.'product_download` pd WHERE (pd.`id_product` = p.`id_product`))' : '').

            ($exclude_packs ? 'AND (p.`cache_is_pack` IS NULL OR p.`cache_is_pack` = 0)' : '').

            'AND ps.`id_shop` IN ('.implode(',', Shop::getContextListShopID()).') GROUP BY p.`id_product`';



        return Db::getInstance()->executeS($sql);

    }

}

