<?php

/**

 * An abstract accessories group product of the module.

 *

 * @author    PrestaMonster.com | support@prestamonster.com

 * @copyright PrestaMonster.com

 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)

 */



class HsAccessoriesGroupProductAbstract extends ObjectModel

{

    /**

     * id of accessory group product.

     *

     * @var int(11)

     */

    public $id_accessory_group_product;



    /**

     * id of product short name.

     *

     * @var int(11)

     */

    public $id_accessory_group;



    /**

     * id of product short name.

     *

     * @var int(11)

     */

    public $id_product;



    /**

     * minimum quantity of accessory.

     *

     * @var int(11)

     */

    public $default_quantity;



    /**

     * id of product short name.

     *

     * @var int(11)

     */

    public $id_product_attribute;



    /**

     * id of product short name.

     *

     * @var int(11)

     */

    public $id_accessory;



    /**

     * short name of a accessory.

     *

     * @var varchar(50)

     */

    public $name;



    /**

     * Required buy product & accessory together.

     *

     * @var int(1)

     */

    public $required;



    /**

     * Current possition of this accessory product.

     *

     * @var int

     */

    public $position;



    /**

     * define field.

     *

     * @var array

     */

    public static $definition = array(

        'table' => 'accessory_group_product',

        'primary' => 'id_accessory_group_product',

        'multilang' => true,

        'fields' => array(

            'id_accessory_group' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'id_product' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'position' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'default_quantity' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'id_product_attribute' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'id_accessory' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'required' => array('type' => self::TYPE_INT, 'validate' => 'isUnsignedId'),

            'name' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'required' => true, 'size' => 128),

        ),

    );



    /**

     * Get id accessory group product.

     *

     * @param int $id_accessory

     * @param int $id_product

     * @param int $id_accessory_group

     * @param int $id_product_attribute

     *

     * @return int

     */

    public static function getIdAccessoryGroupProduct($id_accessory, $id_product, $id_accessory_group, $id_product_attribute = 0)

    {

        $sql = 'SELECT `id_accessory_group_product` FROM `'._DB_PREFIX_.'accessory_group_product` WHERE 1 = 1

					AND `id_accessory` = '.(int) $id_accessory.'

					AND `id_accessory_group` = '.(int) $id_accessory_group.'

					AND `id_product` = '.(int) $id_product.

                (!empty($id_product_attribute) ? ' AND `id_product_attribute` = '.(int) $id_product_attribute : '');



        return Db::getInstance()->getValue($sql);

    }



    /**

     * Get all records of table accessory_group_product.

     *

     * @return array()

     *                 array(<pre>

     *                 'id_accessory_group' => int

     *                 'id_accessory_group_product' => int

     *                 'id_product' => int

     *                 'id_product_attribute' => int

     *                 'id_accessory' => int

     *                 )</pre>

     */

    public static function getAccessoryGroupProducts()

    {

        $sql = 'SELECT * FROM `'._DB_PREFIX_.'accessory_group_product`';



        return Db::getInstance()->executeS($sql);

    }



    /**

     * Get add records of table product_short_name_lang.

     *

     * @return array

     *               array(<pre>

     *               'id_product_short_name' => int

     *               'id_lang' => int

     *               'name' => string

     *               )</pre>

     */

    public static function getShortNames()

    {

        $sql = 'SELECT * FROM `'._DB_PREFIX_.'product_short_name_lang`';



        return Db::getInstance()->executeS($sql);

    }



    /**

     * Get add records of table product_short_name_lang.

     *

     * @return array

     *               array(<pre>

     *               'id_product_short_name' => int

     *               'id_lang' => int

     *               'name' => string

     *               )</pre>

     */

    public static function getAccessoryName($id_product_short_name)

    {

        $sql = 'SELECT * FROM `'._DB_PREFIX_.'accessory_group_product_lang` WHERE id_accessory_group_product ='.(int) $id_product_short_name;

        $results = Db::getInstance()->executeS($sql);

        $languages = array();

        foreach ($results as $result) {

            $languages[$result['id_lang']] = $result['name'];

        }



        return $languages;

    }



    /**

     * Get all id accessory group products by id_accessory.

     *

     * @param int $id_accessory

     *

     * @return int

     */

    protected static function getIdAccessoryGroupProductsByIdAccessory($id_accessory)

    {

        $sql = 'SELECT `id_accessory_group_product` FROM `'._DB_PREFIX_.'accessory_group_product` WHERE `id_accessory` = '.(int) $id_accessory;



        return Db::getInstance()->executeS($sql);

    }



    /**

     * Update global name of accessory.

     *

     * @param int   $id_accessory

     * @param array $names

     *

     * @return bool

     */

    public static function updateGlobalName($id_accessory, $names)

    {

        $flage = true;

        $id_accessories = self::getIdAccessoryGroupProductsByIdAccessory($id_accessory);

        if (!empty($id_accessories)) {

            $values = array();

            foreach ($id_accessories as $id_accessory) {

                foreach ($names as $id_lang => $name) {

                    $values[] = '('.(int) $id_accessory['id_accessory_group_product'].',"'.$name.'",'.(int) $id_lang.')';

                }

            }

            if (!empty($values)) {

                $sql = 'REPLACE INTO `'._DB_PREFIX_.'accessory_group_product_lang`(`id_accessory_group_product`,`name`,`id_lang`) VALUES'.implode(',', $values);

                $flage = Db::getInstance()->execute($sql);

            }

        }



        return $flage;

    }



    /**

     * Duplicate accessory group products.

     *

     * @param int $old_id_product

     * @param int $id_product

     *

     * @return bool

     */

    public static function duplicateAccessories($old_id_product, $id_product)

    {

        $flag = true;

        $id_accessory_group_products = self::getIdAccessoryGroupProductsByIdProduct($old_id_product);

        if (!empty($id_accessory_group_products)) {

            foreach ($id_accessory_group_products as $id_accessory_group_product) {

                $accessory = new HsAccessoriesGroupProduct($id_accessory_group_product['id_accessory_group_product']);

                $accessory->id_product = $id_product;

                unset($accessory->id_accessory_group_product);

                $flag = $flag && $accessory->add();

            }

        }



        return $flag;

    }



    /**

     * Get all id accessories group product by id product.

     *

     * @param type $id_product

     *

     * @return array

     *               array(

     *               0 => array(

     *               'id_accessory_group_product'=> int

     *               ),

     *               1 => array(

     *               'id_accessory_group_product'=> int

     *               ),

     *               )

     */

    protected static function getIdAccessoryGroupProductsByIdProduct($id_product)

    {

        $sql = 'SELECT `id_accessory_group_product` FROM `'._DB_PREFIX_.'accessory_group_product` WHERE `id_product` = '.(int) $id_product;



        return Db::getInstance()->executeS($sql);

    }



    /**

     * Get the higher accessory product position from a group accessory.

     *

     * @param int $id_accessory_group

     *

     * @return int $position

     */

    public static function getHighestPosition($id_accessory_group)

    {

        $sql = 'SELECT MAX(`position`)

                FROM `'._DB_PREFIX_.'accessory_group_product`

                WHERE id_accessory_group = '.(int) $id_accessory_group;

        $position = DB::getInstance()->getValue($sql);



        return (is_numeric($position)) ? $position : -1;

    }

}

