
var AttrLinks = new function()
{
	this.Init = function()
	{
		$('a.color_pick').click(AttrLinks._selectColor);
		
		// Replace select with links
		$('#attributes select.attribute_select').each(function()
		{
			var $select = $(this);
			var $group = $('<ul></ul>');
			var id_attribute_group = $select.attr('id').split('_')[1];

			$group.attr('id', 'attr_group_'+id_attribute_group);
			$group.addClass('attrlinks');
			
			$('option', this).each(function()
			{
				var $option = $(this);
				var $attr = $('<li></li>');
				var $link = $('<a></a>')
				var id_attribute = $option.attr('value');
				var info = AttrLinks._getAttributeInfo(id_attribute);
				
				$attr.attr('id', 'attr_'+id_attribute_group+'_'+id_attribute);
				$attr.addClass('attribute');

				$link.text($option.text());
				$link.attr('href', '#/'+info.group + '-' + info.attribute);
				$link.click(AttrLinks._selectAttribute);
				
				$link.appendTo($attr);
				$attr.appendTo($group);
			});
			
			$select.after($group);
			$select.hide();
		});
		
		AttrLinks._update();
	}
	
	this._getAttributeInfo = function(id_attribute)
	{
		for(var a in attributesCombinations)
			if(attributesCombinations[a].id_attribute == id_attribute)
				return attributesCombinations[a];
			
		return null;
	}
	
	this._selectAttribute = function()
	{
		var id = $(this).parent('li').attr('id').split('_');
		var id_attribute_group = id[1];
		var id_attribute = id[2];
		var $group = $('#group_'+id_attribute_group);
		
		$group.val(id_attribute);
		$group.change();
		AttrLinks._update();
		
		return false;
	}
	
	this._selectColor = function()
	{
 		var id_attribute = $(this).attr('id').split('_')[1];
		$(this).parents('.attribute_list').find('input.color_pick_hidden').val(id_attribute);
		AttrLinks._update();
	}
	
	this._update = function()
	{
		// Remove all clasess
		$('li.attribute').removeClass('selected out availible unavailible');
		$('a.color_pick').parent().removeClass('out availible unavailible');

		// Scan groups
		$('#attributes select.attribute_select, #attributes input.color_pick_hidden').each(function()
		{
			var $input = $(this);			
			var id_attribute_group = $input.attr('name').split('_')[1];
			var id_attribute = $input.val();
			var other_attrs = new Array();

			// Get other selected attributes
			$('#attributes select.attribute_select, #attributes input.color_pick_hidden').not('[name="group_'+id_attribute_group+'"]').each(function()
			{
				other_attrs.push($(this).val());
			});
			
			
			if($input.prop('tagName') == 'SELECT')
			{
				$('option', this).each(function()
				{
					var id_attribute = $(this).val();
					AttrLinks._updateGroup(other_attrs, id_attribute_group, id_attribute, $('li#attr_'+id_attribute_group+'_'+id_attribute));
				});

				// Set selected
				$('li#attr_'+id_attribute_group+'_'+id_attribute).addClass('selected');//selected
			}
			else
			{
				$input.parent().find('a.color_pick').each(function()
				{
					var id_attribute = $(this).attr('id').split('_')[1];
					AttrLinks._updateGroup(other_attrs, id_attribute_group, id_attribute, $(this).parent());
				});
			}
		});			
	
	}
	
	this._updateGroup = function(other, id_attribute_group, id_attribute, $target)
	{
		var attrs = AttrLinks._addToNewArray(other, id_attribute);
		var combination = AttrLinks._validateCombination(attrs);
	
		if(combination)
		{
			if(combination['quantity'] > 0)
				$target.addClass('availible');
			else
				$target.addClass('out');	
		}
		else
			$target.addClass('unavailible');
	}
	
	this._addToNewArray = function(ar, obj)
	{
		var new_ar = ar.slice();
		new_ar.push(obj);
		return new_ar;
	}
	
	this._validateCombination = function(attrs)
	{
		for (var c = 0; c < combinations.length; c++)
		{
			var combinationMatch = true;
			for(var a = 0; a < attrs.length; a++)
				if (!in_array(attrs[a], combinations[c]['idsAttributes']))
					combinationMatch = false;
			
			//TODO maybe check combination count
			if(combinationMatch)
				return combinations[c];
		}
		return false;
	}	
}

$(document).ready(AttrLinks.Init);
