function addToArray(ar, obj)
{
	var new_ar = ar.slice();
	new_ar.push(obj);
	return new_ar;
}

function validateCombination(attrs)
{
	for (var c = 0; c < combinations.length; c++)
	{
		var combinationMatch = true;
		for(var a = 0; a < attrs.length; a++)
			if (!in_array(attrs[a], combinations[c]['idsAttributes']))
				combinationMatch = false;
		
		//TODO maybe check combination count
		if(combinationMatch)
			return combinations[c];
	}
	return false;
}

function updateAttributeLinks()
{
	//remove all clasess
	$('li.attribute').removeClass('selected out availible unavailible');
			
	//Going thru each group
	$('#attributes select').each(function()
	{
		var id = $(this).attr('id');
		var group_id = id.split('_')[1];
		var attr_id = $(this).val();
		var other_attrs = new Array();

		//get other selected attributes
		$('#attributes select').not('#attributes select#group_'+group_id).each(function()
		{
			other_attrs.push($(this).val());
		});

		$('option', this).each(function()
		{
			var attr_id = $(this).val();
			var attrs = addToArray(other_attrs, attr_id);
			
			var combination = validateCombination(attrs);

			if(combination)
			{
				if(combination['quantity'] > 0)
					$('li#attr_'+group_id+'_'+attr_id).addClass('availible'); //availible
				else
					$('li#attr_'+group_id+'_'+attr_id).addClass('out'); //out	
			}
			else
				$('li#attr_'+group_id+'_'+attr_id).addClass('unavailible');//unavailible
		});

		//set selected
		$('li#attr_'+group_id+'_'+attr_id).addClass('selected');//selected
	});		
}

$(document).ready(function()
{
	$('div#attributes').after($('div#attrlinks')).hide();
	$('#attributes select').change(function(){ updateAttributeLinks(); });
	$('a.color_pick').click(function(){ updateAttributeLinks(); });		
	$('li.attribute').click(function()
	{
		var id = $(this).attr('id').split('_');
		var group_id = id[1];
		var attr_id = id[2];
		$('#group_'+group_id).val(attr_id);
		updateAttributeLinks();
		findCombination();
		$('#wrapResetImages').show('slow');
	});

	updateAttributeLinks();
});
