<?php
/**
 *  Attribute links module for PrestaShop 1.5+
 *
 *  2008-2013 SwampyFoot 
 *
 *  @author	Domas Labokas <domas@swampyfoot.com>
 *  @copyright  Copyright (c) 2013, SwampyFoot
 *  @version	2.0
 *  @license	End User License Agreement (EULA)
 *  @link	http://www.swampyfoot.com
 *   
 */

if (!defined('_PS_VERSION_') || (float)_PS_VERSION_ < 1.5)
	exit;
	
class AttrLinks extends Module
{
	function __construct()
	{
		$this->name = 'attrlinks';
		$this->tab = 'front_office_features';
		$this->version = '2.0';
		$this->author = 'SwampyFoot';
		$this->module_key = 'c368a6b0c6eb6453740c1ec30f934223';
	
		parent::__construct();
	
		$this->displayName = $this->l('Attribute links');
		$this->description = $this->l('Displays sorted attributes as links with specific classes');
	}

	function install()
	{	    
		return (parent::install() && $this->registerHook('displayHeader'));
	}

	function hookDisplayHeader($params)
	{
		if(get_class($this->context->controller) == 'ProductController')
		{
			$this->context->controller->addJS($this->_path.'views/js/attrlinks.js');
			$this->context->controller->addCSS($this->_path.'views/css/attrlinks.css');
		}
	}
}
